/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class DTNestingTest
extends AbstractDTAnalysisTest {
    @Test
    public void testDTnestedEverywhere() {
        List validate = validator.validate(this.getReader("DTnestedEverywhere.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        this.checkPositiveTableNestedInSubcontextOfDecision(validate);
        this.checkNegativeTableInBKM(validate);
    }

    private void checkPositiveTableNestedInSubcontextOfDecision(List<DMNMessage> validate) {
        DTAnalysis analysis = this.getAnalysis(validate, "_83a8fbd6-ffcb-4068-ab6a-4a19086ce9c7");
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)1));
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound(Interval.NEG_INF, Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null)))));
        Assert.assertThat(gaps, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.contains((Object[])gaps.toArray()));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)0));
    }

    private void checkNegativeTableInBKM(List<DMNMessage> validate) {
        DTAnalysis analysis = this.getAnalysis(validate, "_68839ac9-1d1b-4e12-9c4f-6b9048b860e1");
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)1));
        List<Hyperrectangle> gaps = Arrays.asList(new Hyperrectangle(1, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)))));
        Assert.assertThat(gaps, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.contains((Object[])gaps.toArray()));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)0));
    }
}

