/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorDecisionTableTest
extends AbstractValidatorTest {
    @Test
    public void testDTABLE_EMPTY_ENTRY() {
        List validate = validator.validate(this.getReader("DTABLE_EMPTY_ENTRY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testDTABLE_MULTIPLEOUT_NAME() {
        List validate = validator.validate(this.getReader("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
    }

    @Test
    public void testDTABLE_PRIORITY_MISSING_OUTVALS() {
        List validate = validator.validate(this.getReader("DTABLE_PRIORITY_MISSING_OUTVALS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_OUTPUT_VALUES)));
    }

    @Test
    public void testDTABLE_SINGLEOUT_NONAME() {
        List validate = validator.validate(this.getReader("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_TYPEREF)));
    }
}

