/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorKnowledgeSourceTest
extends AbstractValidatorTest {
    @Test
    public void testKNOW_SOURCE_MISSING_OWNER_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("knowledgesource/KNOW_SOURCE_MISSING_OWNER.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testKNOW_SOURCE_MISSING_OWNER_FileInput() {
        List validate = validator.validate(this.getFile("knowledgesource/KNOW_SOURCE_MISSING_OWNER.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testKNOW_SOURCE_MISSING_OWNER_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("knowledgesource/KNOW_SOURCE_MISSING_OWNER.dmn", "https://github.com/kiegroup/kie-dmn", "KNOW_SOURCE_MISSING_OWNER"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testKNOW_SOURCE_OWNER_NOT_ORG_UNIT_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("knowledgesource/KNOW_SOURCE_OWNER_NOT_ORG_UNIT.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)3));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testKNOW_SOURCE_OWNER_NOT_ORG_UNIT_FileInput() {
        List validate = validator.validate(this.getFile("knowledgesource/KNOW_SOURCE_OWNER_NOT_ORG_UNIT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testKNOW_SOURCE_OWNER_NOT_ORG_UNIT_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("knowledgesource/KNOW_SOURCE_OWNER_NOT_ORG_UNIT.dmn", "https://github.com/kiegroup/kie-dmn", "KNOW_SOURCE_OWNER_NOT_ORG_UNIT"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }
}

