/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_3.TDecision;
import org.kie.dmn.validation.MessageReporter;

public class MessageReporterTest {
    private static final Msg.Message0 m0 = new Msg.Message0(DMNMessageType.KIE_API, "Hello World.");
    private static final Msg.Message1 m1 = new Msg.Message1(DMNMessageType.KIE_API, "Hello World %s");
    private static final Msg.Message2 m2 = new Msg.Message2(DMNMessageType.KIE_API, "Hello World %s %s");
    private static final Msg.Message3 m3 = new Msg.Message3(DMNMessageType.KIE_API, "Hello World %s %s %s");
    private static final Msg.Message4 m4 = new Msg.Message4(DMNMessageType.KIE_API, "Hello World %s %s %s %s");

    @Test
    public void smokeTest() {
        MessageReporter ut = new MessageReporter();
        ut.report(DMNMessage.Severity.INFO, this.aDecision(), m0);
        ut.report(DMNMessage.Severity.INFO, this.aDecision(), m1, (Object)1);
        ut.report(DMNMessage.Severity.INFO, this.aDecision(), m2, (Object)1, (Object)2);
        ut.report(DMNMessage.Severity.INFO, this.aDecision(), m3, (Object)1, (Object)2, (Object)3);
        ut.report(DMNMessage.Severity.INFO, this.aDecision(), m4, (Object)1, (Object)2, (Object)3, (Object)4);
        Assertions.assertThat((List)ut.getMessages().getMessages()).hasSize(5);
        Assertions.assertThat((String)((DMNMessage)ut.getMessages().getMessages().get(0)).getText()).contains(new CharSequence[]{"Hello World"});
        Assertions.assertThat((String)((DMNMessage)ut.getMessages().getMessages().get(1)).getText()).contains(new CharSequence[]{"Hello World 1"});
        Assertions.assertThat((String)((DMNMessage)ut.getMessages().getMessages().get(2)).getText()).contains(new CharSequence[]{"Hello World 1 2"});
        Assertions.assertThat((String)((DMNMessage)ut.getMessages().getMessages().get(3)).getText()).contains(new CharSequence[]{"Hello World 1 2 3"});
        Assertions.assertThat((String)((DMNMessage)ut.getMessages().getMessages().get(4)).getText()).contains(new CharSequence[]{"Hello World 1 2 3 4"});
    }

    private DMNModelInstrumentedBase aDecision() {
        TDecision d = new TDecision();
        d.setId(UUID.randomUUID().toString());
        return d;
    }
}

