/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorTypeRefTest
extends AbstractValidatorTest {
    @Test
    public void testTYPEREF_NO_FEEL_TYPE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("typeref/TYPEREF_NO_FEEL_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
        }
    }

    @Test
    public void testTYPEREF_NO_FEEL_TYPE_FileInput() {
        List validate = validator.validate(this.getFile("typeref/TYPEREF_NO_FEEL_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
    }

    @Test
    public void testTYPEREF_NO_FEEL_TYPE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("typeref/TYPEREF_NO_FEEL_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "TYPEREF_NO_FEEL_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
    }

    @Test
    public void testTYPEREF_NO_NS_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("typeref/TYPEREF_NO_NS.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
        }
    }

    @Test
    public void testTYPEREF_NO_NS_FileInput() {
        List validate = validator.validate(this.getFile("typeref/TYPEREF_NO_NS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
    }

    @Test
    public void testTYPEREF_NO_NS_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("typeref/TYPEREF_NO_NS.dmn", "https://github.com/kiegroup/kie-dmn", "TYPEREF_NO_NS"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("typeref/TYPEREF_NOT_FEEL_NOT_DEF.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME))).isTrue();
            Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
        }
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF_FileInput() {
        List validate = validator.validate(this.getFile("typeref/TYPEREF_NOT_FEEL_NOT_DEF.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("typeref/TYPEREF_NOT_FEEL_NOT_DEF.dmn", "https://github.com/kiegroup/kie-dmn", "TYPEREF_NOT_FEEL_NOT_DEF"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF_valid_ResourceInput() throws IOException {
        try (Reader reader = this.getReader("typeref/TYPEREF_NOT_FEEL_NOT_DEF_valid.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
        }
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF_valid_FileInput() {
        List validate = validator.validate(this.getFile("typeref/TYPEREF_NOT_FEEL_NOT_DEF_valid.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testTYPEREF_NOT_FEEL_NOT_DEF_valid_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("typeref/TYPEREF_NOT_FEEL_NOT_DEF_valid.dmn", "https://github.com/kiegroup/kie-dmn", "TYPEREF_NOT_FEEL_NOT_DEF_valid"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testBKM_WITH_NO_TYPEREF_IS_OK_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("typeref/BKM_WITH_NO_TYPEREF_IS_OK.dmn", "http://www.trisotech.com/dmn/definitions/_7e8d7561-657a-4729-b2a9-5a6279df6d5d", "Drawing 1"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }
}

