/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.documentation.rest;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.remote.client.api.RemoteRestRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteRuntimeEngineFactory;
import org.kie.remote.client.documentation.objects.MyType;

public class RestJavaApiExamples {
    public void simpleRestBuilderExample() throws Exception {
        String appName = "kie-wb";
        String deploymentId = "com.burns.reactor:homer:1.0";
        String serverInstanceUrl = "http://localhost:8080/" + appName;
        RuntimeEngine engine = ((RemoteRestRuntimeEngineBuilder)((RemoteRestRuntimeEngineBuilder)((RemoteRestRuntimeEngineBuilder)RemoteRuntimeEngineFactory.newRestBuilder().addDeploymentId(deploymentId)).addUrl(new URL(serverInstanceUrl)).addUserName("homer")).addPassword("d0nut5R!!!")).build();
        KieSession kieSessionClient = engine.getKieSession();
    }

    public void startProcessAndHandleTaskViaRestRemoteJavaAPI(URL serverRestUrl, String deploymentId, String user, String password) {
        RuntimeEngine engine = ((RemoteRestRuntimeEngineBuilder)((RemoteRestRuntimeEngineBuilder)((RemoteRestRuntimeEngineBuilder)((RemoteRestRuntimeEngineBuilder)((RemoteRestRuntimeEngineBuilder)RemoteRuntimeEngineFactory.newRestBuilder().addUrl(serverRestUrl).addTimeout(5)).addDeploymentId(deploymentId)).addUserName(user)).addPassword(password)).addExtraJaxbClasses(new Class[]{MyType.class})).build();
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        HashMap<String, MyType> params = new HashMap<String, MyType>();
        params.put("paramName", new MyType("name", 23));
        ProcessInstance processInstance = ksession.startProcess("com.burns.reactor.maintenance.cycle", params);
        long procId = processInstance.getId();
        String taskUserId = user;
        taskService = engine.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        long taskId = -1L;
        for (TaskSummary task : tasks) {
            if (task.getProcessInstanceId() != procId) continue;
            taskId = task.getId();
        }
        if (taskId == -1L) {
            throw new IllegalStateException("Unable to find task for " + user + " in process instance " + procId);
        }
        taskService.start(taskId, taskUserId);
        HashMap resultData = new HashMap();
        taskService.complete(taskId, taskUserId, resultData);
    }
}

