/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.rest.backend.documentation;

import java.io.IOException;
import java.util.ArrayList;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.rest.client.OrganizationalUnit;
import org.guvnor.rest.client.ProjectResponse;
import org.guvnor.rest.client.UpdateOrganizationalUnit;
import org.junit.Test;

public class GuvnorSerializationExamplesTest {
    @Test
    public void getProjectsJsonExample() throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<ProjectResponse> projectRequests = new ArrayList<ProjectResponse>(2);
        ProjectResponse projectReq = new ProjectResponse();
        GAV projectGAV = new GAV("com.acme", "my-project-artifact-id", "1.0");
        projectReq.setGroupId(projectGAV.getGroupId());
        projectReq.setName(projectGAV.getArtifactId());
        projectReq.setVersion(projectGAV.getVersion());
        projectReq.setName("my-project-name");
        projectReq.setDescription("Project to illustrate REST output");
        projectRequests.add(projectReq);
        projectReq = new ProjectResponse();
        projectGAV = new GAV("com.acme", "yap", "2.2.1");
        projectReq.setGroupId(projectGAV.getGroupId());
        projectReq.setName(projectGAV.getArtifactId());
        projectReq.setVersion(projectGAV.getVersion());
        projectReq.setName("yet-another-project-name");
        projectReq.setDescription("Yet Another Project to illustrate REST output");
        projectRequests.add(projectReq);
        ObjectMapper om = new ObjectMapper();
        System.out.println(om.writerWithDefaultPrettyPrinter().writeValueAsString(projectRequests));
    }

    @Test
    public void getOrganizationalUnitsExample() throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<OrganizationalUnit> orgUnits = new ArrayList<OrganizationalUnit>();
        OrganizationalUnit orgUnit = new OrganizationalUnit();
        orgUnit.setName("EmployeeWage");
        orgUnit.setOwner("Employee");
        orgUnit.setDefaultGroupId("org.bpms");
        ArrayList<String> repoNames = new ArrayList<String>();
        repoNames.add("EmployeeRepo");
        repoNames.add("OtherRepo");
        orgUnit.setRepositories(repoNames);
        orgUnits.add(orgUnit);
        orgUnit = new OrganizationalUnit();
        orgUnit.setName("OrgUnitName");
        orgUnit.setOwner("OrgUnitOwner");
        orgUnit.setDefaultGroupId("org.group.id");
        repoNames = new ArrayList();
        repoNames.add("repository-name-1");
        repoNames.add("repository-name-2");
        orgUnit.setRepositories(repoNames);
        orgUnits.add(orgUnit);
        ObjectMapper om = new ObjectMapper();
        System.out.println(om.writerWithDefaultPrettyPrinter().writeValueAsString(orgUnits));
    }

    @Test
    public void updateOrganizationalUnitExample() throws JsonGenerationException, JsonMappingException, IOException {
        UpdateOrganizationalUnit updateOrgUnit = new UpdateOrganizationalUnit();
        updateOrgUnit.setOwner("NewOwner");
        updateOrgUnit.setDefaultGroupId("org.new.default.group.id");
        ObjectMapper om = new ObjectMapper();
        System.out.println(om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)updateOrgUnit));
        String jsonStr = "{ \"name\" : null,  \"owner\" : \"NewOwner\",  \"defaultGroupId\" : \"org.new.default.group.id\" }";
        updateOrgUnit = (UpdateOrganizationalUnit)om.readValue(jsonStr, UpdateOrganizationalUnit.class);
        String name = updateOrgUnit.getClass().getName();
    }
}

