    public void startProcessViaJmsRemoteJavaAPIInitialContext(String hostname, int jmsConnPort, 
            String deploymentId, String user, String password,
            String processId) {

        // See your application server documentation for how to initialize
        // a remote InitialContext instance for your server instance
        InitialContext remoteInitialContext = getRemoteInitialContext();

        RuntimeEngine engine = RemoteRuntimeEngineFactory.newJmsBuilder()
                .addDeploymentId(deploymentId)
                .addRemoteInitialContext(remoteInitialContext)
                .addUserName(user)
                .addPassword(password)
                .build();

        // Create KieSession instances and use them
        KieSession ksession = engine.getKieSession();
        
        // Each operation on a KieSession, TaskService or AuditLogService (client) instance 
        // sends a request for the operation to the server side and waits for the response
        // If something goes wrong on the server side, the client will throw an exception. 
        ProcessInstance processInstance = ksession.startProcess(processId);
        long procId = processInstance.getId();
    }    