    public void startProcessAndHandleTaskViaRestRemoteJavaAPI(URL serverRestUrl, String deploymentId, String user, String password) {
        // the serverRestUrl should contain a URL similar to "http://localhost:8080/jbpm-console/"
        
        // Setup the factory class with the necessarry information to communicate with the REST services
        RuntimeEngine engine = RemoteRuntimeEngineFactory.newRestBuilder()
            .addUrl(serverRestUrl)
            .addTimeout(5)
            .addDeploymentId(deploymentId)
            .addUserName(user)
            .addPassword(password)
            // if you're sending custom class parameters, make sure that
            // the remote client instance knows about them! 
            .addExtraJaxbClasses(MyType.class)
            .build();

        // Create KieSession and TaskService instances and use them
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();

        // Each operation on a KieSession, TaskService or AuditLogService (client) instance 
        // sends a request for the operation to the server side and waits for the response
        // If something goes wrong on the server side, the client will throw an exception. 
        Map&lt;String, Object&gt; params = new HashMap&lt;String, Object&gt;();
        params.put("paramName", new MyType("name", 23));
        ProcessInstance processInstance 
            = ksession.startProcess("com.burns.reactor.maintenance.cycle", params);
        long procId = processInstance.getId();

        String taskUserId = user;
        taskService = engine.getTaskService();
        List&lt;TaskSummary&gt; tasks = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");

        long taskId = -1;
        for (TaskSummary task : tasks) {
            if (task.getProcessInstanceId() == procId) {
                taskId = task.getId();
            }
        }

        if (taskId == -1) {
            throw new IllegalStateException("Unable to find task for " + user + 
                    " in process instance " + procId);
        }

        taskService.start(taskId, taskUserId);
      
        // resultData can also just be null
        Map&lt;String, Object&gt; resultData = new HashMap&lt;String, Object&gt;(); 
        taskService.complete(taskId, taskUserId, resultData);
    }    