/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.documentation.jms;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.TaskSummary;
import org.kie.remote.client.api.RemoteRuntimeEngineFactory;
import org.kie.remote.client.api.exception.MissingRequiredInfoException;
import org.kie.remote.client.api.exception.RemoteApiException;
import org.kie.remote.client.api.exception.RemoteCommunicationException;
import org.kie.remote.client.jaxb.ClientJaxbSerializationProvider;
import org.kie.remote.client.jaxb.JaxbCommandsRequest;
import org.kie.remote.client.jaxb.JaxbCommandsResponse;
import org.kie.remote.jaxb.gen.AuditCommand;
import org.kie.remote.jaxb.gen.GetTaskAssignedAsPotentialOwnerCommand;
import org.kie.remote.jaxb.gen.StartProcessCommand;
import org.kie.remote.jaxb.gen.TaskCommand;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.SerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendJmsExamplesTODO {
    protected static final Logger logger = LoggerFactory.getLogger(SendJmsExamplesTODO.class);

    public void sendCommandsViaJms(String user, String password, String connectionUser, String connectionPassword, String deploymentId, String processId, String hostName) {
        Queue responseQueue;
        Queue sendQueue;
        ConnectionFactory connectionFactory;
        InitialContext context = RemoteRuntimeEngineFactory.getRemoteJbossInitialContext((String)hostName, (String)connectionUser, (String)connectionPassword);
        try {
            connectionFactory = (ConnectionFactory)context.lookup("jms/RemoteConnectionFactory");
        }
        catch (NamingException ne) {
            throw new RuntimeException("Unable to lookup JMS connection factory.", ne);
        }
        try {
            Queue sessionQueue;
            sendQueue = sessionQueue = (Queue)context.lookup("jms/queue/KIE.SESSION");
            Queue taskQueue = (Queue)context.lookup("jms/queue/KIE.TASK");
            responseQueue = (Queue)context.lookup("jms/queue/KIE.RESPONSE");
        }
        catch (NamingException ne) {
            throw new RuntimeException("Unable to lookup send or response queue", ne);
        }
        StartProcessCommand startProcCmd = new StartProcessCommand();
        startProcCmd.setProcessId(processId);
        JaxbSerializationProvider serializationProvider = ClientJaxbSerializationProvider.newInstance();
        ProcessInstance procInst = (ProcessInstance)SendJmsExamplesTODO.sendJmsCommand((Command)startProcCmd, connectionUser, connectionPassword, user, password, deploymentId, null, connectionFactory, sendQueue, responseQueue, (SerializationProvider)serializationProvider, Collections.EMPTY_SET, 0, 5000L);
        GetTaskAssignedAsPotentialOwnerCommand gtaapoCmd = new GetTaskAssignedAsPotentialOwnerCommand();
        gtaapoCmd.setUserId(user);
        Long processInstanceId = null;
        List taskSumList = (List)SendJmsExamplesTODO.sendJmsCommand((Command)gtaapoCmd, connectionUser, connectionPassword, user, password, deploymentId, processInstanceId, connectionFactory, sendQueue, responseQueue, (SerializationProvider)serializationProvider, Collections.EMPTY_SET, 0, 5000L);
        long taskId = ((TaskSummary)taskSumList.get(0)).getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object sendJmsCommand(Command command, String connUser, String connPassword, String userName, String password, String deploymentId, Long processInstanceId, ConnectionFactory factory, Queue sendQueue, Queue responseQueue, SerializationProvider serializationProvider, Set<Class<?>> extraJaxbClasses, int serializationType, long timeoutInMillisecs) {
        List responses;
        if (deploymentId == null && !(command instanceof TaskCommand) && !(command instanceof AuditCommand)) {
            throw new MissingRequiredInfoException("A deployment id is required when sending commands involving the KieSession.");
        }
        JaxbCommandsRequest req = command instanceof AuditCommand ? new JaxbCommandsRequest(command) : new JaxbCommandsRequest(deploymentId, command);
        req.setProcessInstanceId(processInstanceId);
        req.setUser(userName);
        req.setVersion("6.4.0.1");
        Connection connection = null;
        Session session = null;
        JaxbCommandsResponse cmdResponse = null;
        String corrId = UUID.randomUUID().toString();
        String selector = "JMSCorrelationID = '" + corrId + "'";
        try {
            Message response;
            TextMessage textMsg;
            MessageConsumer consumer;
            MessageProducer producer;
            try {
                connection = password != null ? factory.createConnection(connUser, connPassword) : factory.createConnection();
                session = connection.createSession(false, 1);
                producer = session.createProducer((Destination)sendQueue);
                consumer = session.createConsumer((Destination)responseQueue, selector);
                connection.start();
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to setup a JMS connection.", (Throwable)jmse);
            }
            try {
                boolean isTaskCommand;
                String xmlStr = serializationProvider.serialize((Object)req);
                textMsg = session.createTextMessage(xmlStr);
                textMsg.setJMSCorrelationID(corrId);
                textMsg.setIntProperty("serialization", serializationType);
                if (extraJaxbClasses != null && !extraJaxbClasses.isEmpty()) {
                    if (deploymentId == null) {
                        throw new MissingRequiredInfoException("Deserialization of parameter classes requires a deployment id, which has not been configured.");
                    }
                    textMsg.setStringProperty("deploymentId", deploymentId);
                }
                if (isTaskCommand = command instanceof TaskCommand) {
                    if (userName == null) {
                        throw new RemoteCommunicationException("A user name is required when sending task operation requests via JMS");
                    }
                    if (password == null) {
                        throw new RemoteCommunicationException("A password is required when sending task operation requests via JMS");
                    }
                    textMsg.setStringProperty("username", userName);
                    textMsg.setStringProperty("password", password);
                }
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to create and fill a JMS message.", (Throwable)jmse);
            }
            catch (SerializationException se) {
                throw new RemoteCommunicationException("Unable to deserialze JMS message.", se.getCause());
            }
            try {
                producer.send((Message)textMsg);
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to send a JMS message.", (Throwable)jmse);
            }
            try {
                response = consumer.receive(timeoutInMillisecs);
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to receive or retrieve the JMS response.", (Throwable)jmse);
            }
            if (response == null) {
                logger.warn("Response is empty");
                Object jmse = null;
                return jmse;
            }
            assert (response != null) : "Response is empty.";
            try {
                String xmlStr = ((TextMessage)response).getText();
                cmdResponse = (JaxbCommandsResponse)serializationProvider.deserialize(xmlStr);
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", (Throwable)jmse);
            }
            catch (SerializationException se) {
                throw new RemoteCommunicationException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", se.getCause());
            }
            assert (cmdResponse != null) : "Jaxb Cmd Response was null!";
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException jmse) {
                    logger.warn("Unable to close connection or session!", (Throwable)jmse);
                }
            }
        }
        String version = cmdResponse.getVersion();
        if (version == null) {
            version = "pre-6.0.3";
        }
        if (!version.equals("6.4.0.1")) {
            logger.info("Response received from server version [{}] while client is version [{}]! This may cause problems.", (Object)version, (Object)"6.4.0.1");
        }
        if ((responses = cmdResponse.getResponses()).size() > 0) {
            JaxbCommandResponse response = (JaxbCommandResponse)responses.get(0);
            if (response instanceof JaxbExceptionResponse) {
                JaxbExceptionResponse exceptionResponse = (JaxbExceptionResponse)response;
                throw new RemoteApiException(exceptionResponse.getMessage());
            }
            return response.getResult();
        }
        assert (responses.size() == 0) : "There should only be 1 response, not " + responses.size() + ", returned by a command!";
        return null;
    }
}

