    public void startProcessAndHandleTaskViaJmsRemoteJavaAPISsl(String hostNameOrIpAdress, int jmsSslConnectorPort,
            String deploymentId, String user, String password, 
            String keyTrustStoreLocation, String keyTrustStorePassword,
            String processId) {

        InitialContext remoteInitialContext = getRemoteInitialContext();
        
        RuntimeEngine engine = RemoteRuntimeEngineFactory.newJmsBuilder()
                .addDeploymentId(deploymentId)
                .addRemoteInitialContext(remoteInitialContext)
                .addUserName(user)
                .addPassword(password)
                .addHostName(hostNameOrIpAdress)
                .addJmsConnectorPort(jmsSslConnectorPort)
                .useKeystoreAsTruststore()
                .addKeystoreLocation(keyTrustStoreLocation)
                .addKeystorePassword(keyTrustStorePassword)
                .build();

        // create JMS request
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess(processId);
        long procInstId = processInstance.getId();
        logger.debug("Started process instance: " + procInstId );

        TaskService taskService = engine.getTaskService();
        List&lt;TaskSummary&gt; taskSumList 
            = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        TaskSummary taskSum = null;
        for( TaskSummary taskSumElem : taskSumList ) { 
            if( taskSumElem.getProcessInstanceId().equals(procInstId) ) {
                taskSum = taskSumElem;
            }
        }
        long taskId = taskSum.getId();
        logger.debug("Found task " + taskId);
        
        // get other info from task if you want to
        Task task = taskService.getTaskById(taskId);
        logger.debug("Retrieved task " + taskId );
        
        taskService.start(taskId, user);
        
        Map&lt;String, Object&gt; resultData = new HashMap&lt;String, Object&gt;();
        // insert results for task in resultData
        taskService.complete(taskId, user, resultData);
        logger.debug("Completed task " + taskId );
    }    