/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.documentation.jms;

import java.util.HashMap;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.remote.client.api.RemoteJmsRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteRuntimeEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsJavaApiExamples {
    private static final String CONNECTION_FACTORY_NAME = "jms/RemoteConnectionFactory";
    private static final String KSESSION_QUEUE_NAME = "jms/queue/KIE.SESSION";
    private static final String TASK_QUEUE_NAME = "jms/queue/KIE.TASK";
    private static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.RESPONSE";
    private static Logger logger = LoggerFactory.getLogger(JmsJavaApiExamples.class);

    public void startProcessViaJmsRemoteJavaAPI(String hostname, int jmsConnPort, String deploymentId, String user, String password, String processId) throws NamingException {
        InitialContext remoteInitialContext = JmsJavaApiExamples.getRemoteInitialContext();
        String queueName = KSESSION_QUEUE_NAME;
        Queue sessionQueue = (Queue)remoteInitialContext.lookup(queueName);
        queueName = TASK_QUEUE_NAME;
        Queue taskQueue = (Queue)remoteInitialContext.lookup(queueName);
        queueName = RESPONSE_QUEUE_NAME;
        Queue responseQueue = (Queue)remoteInitialContext.lookup(queueName);
        String connFactoryName = CONNECTION_FACTORY_NAME;
        ConnectionFactory connFact = (ConnectionFactory)remoteInitialContext.lookup(connFactoryName);
        RuntimeEngine engine = ((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)RemoteRuntimeEngineFactory.newJmsBuilder().addDeploymentId(deploymentId)).addConnectionFactory(connFact).addKieSessionQueue(sessionQueue).addTaskServiceQueue(taskQueue).addResponseQueue(responseQueue).addUserName(user)).addPassword(password)).addHostName(hostname).addJmsConnectorPort(jmsConnPort).disableTaskSecurity().build();
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess(processId);
        long procId = processInstance.getId();
    }

    public void startProcessViaJmsRemoteJavaAPIInitialContext(String hostname, int jmsConnPort, String deploymentId, String user, String password, String processId) {
        InitialContext remoteInitialContext = JmsJavaApiExamples.getRemoteInitialContext();
        RuntimeEngine engine = ((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)RemoteRuntimeEngineFactory.newJmsBuilder().addDeploymentId(deploymentId)).addRemoteInitialContext(remoteInitialContext).addUserName(user)).addPassword(password)).build();
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess(processId);
        long procId = processInstance.getId();
    }

    public void startProcessViaJmsRemoteJavaAPI(String hostNameOrIpAdress, String deploymentId, String user, String password, String processId) {
        RuntimeEngine engine = ((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)RemoteRuntimeEngineFactory.newJmsBuilder().addJbossServerHostName(hostNameOrIpAdress).addDeploymentId(deploymentId)).addUserName(user)).addPassword(password)).build();
    }

    private static InitialContext getRemoteInitialContext() {
        return null;
    }

    public void startProcessAndHandleTaskViaJmsRemoteJavaAPISsl(String hostNameOrIpAdress, int jmsSslConnectorPort, String deploymentId, String user, String password, String keyTrustStoreLocation, String keyTrustStorePassword, String processId) {
        InitialContext remoteInitialContext = JmsJavaApiExamples.getRemoteInitialContext();
        RuntimeEngine engine = ((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)((RemoteJmsRuntimeEngineBuilder)RemoteRuntimeEngineFactory.newJmsBuilder().addDeploymentId(deploymentId)).addRemoteInitialContext(remoteInitialContext).addUserName(user)).addPassword(password)).addHostName(hostNameOrIpAdress).addJmsConnectorPort(jmsSslConnectorPort).useKeystoreAsTruststore().addKeystoreLocation(keyTrustStoreLocation).addKeystorePassword(keyTrustStorePassword).build();
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess(processId);
        long procInstId = processInstance.getId();
        logger.debug("Started process instance: " + procInstId);
        TaskService taskService = engine.getTaskService();
        List taskSumList = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        TaskSummary taskSum = null;
        for (TaskSummary taskSumElem : taskSumList) {
            if (!taskSumElem.getProcessInstanceId().equals(procInstId)) continue;
            taskSum = taskSumElem;
        }
        long taskId = taskSum.getId();
        logger.debug("Found task " + taskId);
        Task task = taskService.getTaskById(taskId);
        logger.debug("Retrieved task " + taskId);
        taskService.start(taskId, user);
        HashMap resultData = new HashMap();
        taskService.complete(taskId, user, resultData);
        logger.debug("Completed task " + taskId);
    }
}

