/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.runtime.kiesession.local.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.kie.api.runtime.KieSession;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoInputDrlKieSessionLocal;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoOutputDrlKieSessionLocal;
import org.kie.drl.engine.runtime.kiesession.local.utils.DrlRuntimeHelper;
import org.kie.efesto.common.api.cache.EfestoClassKey;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.model.EfestoRuntimeContext;
import org.kie.efesto.common.core.utils.JSONUtils;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoLocalRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.KieRuntimeService;
import org.kie.efesto.runtimemanager.core.model.EfestoRuntimeContextUtils;

public class KieRuntimeServiceDrlKieSessionLocal
implements KieRuntimeService<String, KieSession, EfestoInputDrlKieSessionLocal, EfestoOutputDrlKieSessionLocal, EfestoRuntimeContext> {
    private static final ObjectMapper objectMapper = JSONUtils.getObjectMapper();

    public EfestoClassKey getEfestoClassKeyIdentifier() {
        return new EfestoClassKey(EfestoInputDrlKieSessionLocal.class, new Type[]{String.class});
    }

    public boolean canManageInput(EfestoInput toEvaluate, EfestoRuntimeContext context) {
        return DrlRuntimeHelper.canManage(toEvaluate, context);
    }

    public Optional<EfestoOutputDrlKieSessionLocal> evaluateInput(EfestoInputDrlKieSessionLocal toEvaluate, EfestoRuntimeContext context) {
        if (!(context instanceof EfestoLocalRuntimeContext)) {
            context = EfestoRuntimeContextUtils.buildWithParentClassLoader((ClassLoader)context.getClass().getClassLoader(), (Map)context.getGeneratedResourcesMap());
        }
        return DrlRuntimeHelper.execute(toEvaluate, (EfestoLocalRuntimeContext)context);
    }

    public String getModelType() {
        return "drl";
    }

    public Optional<EfestoInputDrlKieSessionLocal> parseJsonInput(String modelLocalUriIdString, String inputDataString) {
        try {
            ModelLocalUriId modelLocalUriId = (ModelLocalUriId)objectMapper.readValue(modelLocalUriIdString, ModelLocalUriId.class);
            return modelLocalUriId.model().equals(this.getModelType()) ? Optional.of(new EfestoInputDrlKieSessionLocal(modelLocalUriId, inputDataString)) : Optional.empty();
        }
        catch (Exception e) {
            throw new KieEfestoCommonException(String.format("Failed to parse %s as ModelLocalUriId", modelLocalUriIdString));
        }
    }
}

