/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eap.test;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Arquillian.class)
public class KieEapModulesSmokeIT {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource("jboss-deployment-structure-drools-and-jbpm-modules.xml", "jboss-deployment-structure.xml")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void deployWarWithDroolsAndJbpmModuleDependencies(@ArquillianResource URL baseUrl) {
        Assert.assertNotNull((Object)baseUrl);
    }

    @Test
    public void createKieSessionFromSimpleDrlAndFireRules() {
        String drl = "package org.kie.eap.test;\n\nrule \"Dummy rule\"\nwhen\n    String( this == \"MyValue\" )\nthen\n    System.out.println(\"Rule fired!\");\nend";
        KieHelper kieHelper = new KieHelper();
        kieHelper.addContent(drl, ResourceType.DRL);
        KieBase kieBase = kieHelper.build(new KieBaseOption[0]);
        Assert.assertEquals((String)("Unexpected number of packages in " + kieBase), (long)1L, (long)kieBase.getKiePackages().size());
        Assert.assertEquals((String)"Unexpected KiePackage name!", (Object)"org.kie.eap.test", (Object)((KiePackage)kieBase.getKiePackages().iterator().next()).getName());
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)"MyValue");
        int rulesFired = kieSession.fireAllRules();
        Assert.assertEquals((String)"Unexpected number of rules fired!", (long)1L, (long)rulesFired);
    }
}

