/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.Node;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLWriter;
import java.io.IOException;
import java.io.StringWriter;

public class BasicNode
implements Node {
    private Token token;
    private XMLTokenizer.Type type;
    private String value;

    public BasicNode(Token token) {
        if (token == null) {
            throw new NullPointerException("token is null");
        }
        this.token = token;
        this.type = token.getType();
    }

    public BasicNode(XMLTokenizer.Type type, String text) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (text == null) {
            text = "";
        }
        this.type = type;
        this.value = text;
    }

    protected void setType(XMLTokenizer.Type type) {
        this.type = type;
    }

    public XMLTokenizer.Type getType() {
        return this.type;
    }

    public Token getToken() {
        return this.token;
    }

    public int getStartOffset() {
        return this.token == null ? -1 : this.token.getStartOffset();
    }

    public int getEndOffset() {
        return this.token == null ? -1 : this.token.getEndOffset();
    }

    public String getValue() {
        if (this.value == null) {
            return this.token.getText();
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public BasicNode toXML(XMLWriter writer) throws IOException {
        writer.write(this, this.getValue());
        return this;
    }

    public String toXML() {
        return BasicNode.toXML(this);
    }

    public String toString() {
        return this.toXML();
    }

    public static String toXML(Node n) {
        StringWriter buffer = new StringWriter();
        XMLWriter writer = new XMLWriter(buffer);
        try {
            n.toXML(writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen", e);
        }
        return buffer.toString();
    }

    public BasicNode createClone() {
        return new BasicNode(this.type, this.value);
    }

    public BasicNode copy(Node orig) {
        BasicNode other = (BasicNode)orig;
        this.token = other.token;
        this.type = other.type;
        this.value = other.value;
        return this;
    }

    public BasicNode copy() {
        BasicNode n = this.createClone();
        n.copy(this);
        return n;
    }
}

