/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.JoinedInputStream;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLStringSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLInputStreamReader
extends Reader {
    public static final String ENCODING_UTF_8 = "UTF-8";
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_ISO_Latin_1 = "ISO-8859-1";
    public static Map<String, String> ENCODING_MAP = new HashMap<String, String>();
    public static Map<String, String> JAVA_TO_XML_ENCODING_MAP;
    private InputStream in;
    private String xmlEncoding;
    private String javaEncoding;
    private Reader delegate;
    public static final Pattern VERSION_PATTERN;

    public XMLInputStreamReader(InputStream in) {
        this.in = in;
    }

    public void determineEncoding() {
        int headerLength;
        if (this.xmlEncoding != null) {
            return;
        }
        String s = "";
        int encodingOffset = 0;
        byte[] header = new byte[1024];
        try {
            headerLength = this.in.read(header);
        }
        catch (IOException e) {
            XMLStringSource source = new XMLStringSource("");
            throw new XMLParseException("Error parsing XML declaration: " + e.getMessage(), e).setSource(source, 0);
        }
        String encoding = ENCODING_UTF_8;
        int skip = 0;
        if (headerLength >= 2) {
            if (header[0] == -2 && header[1] == -1) {
                encoding = "UnicodeBig";
                skip = 2;
            } else if (header[0] == -1 && header[1] == -2) {
                encoding = "UnicodeLittle";
                skip = 2;
                if (headerLength >= 4 && header[2] == 0 && header[3] == 0) {
                    throw new XMLParseException("UTF 32 Little Endian not supported, yet. Patches welcome.");
                }
            } else if (headerLength >= 3) {
                if (header[0] == -17 && header[1] == -69 && header[2] == -65) {
                    encoding = ENCODING_UTF_8;
                    skip = 3;
                } else if (headerLength >= 4) {
                    if (header[0] == 0 && header[1] == 0 && header[2] == -2 && header[3] == -1) {
                        throw new XMLParseException("UTF 32 Big Endian not supported, yet. Patches welcome.");
                    }
                    if (header[0] == 60 && header[1] == 63 && header[2] == 120 && header[3] == 109) {
                        int c;
                        int pos;
                        for (pos = 4; pos < headerLength && (c = header[pos] & 0xFF) != 62; ++pos) {
                            if (Character.isLetter(c) || Character.isDigit(c) || Character.isWhitespace(c) || c == 63 || c == 34 || c == 39 || c == 61 || c == 45 || c == 95 || c == 46) continue;
                            XMLStringSource source = null;
                            try {
                                source = new XMLStringSource(new String(header, "ISO-8859-1"));
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new XMLParseException("Error parsing XML declaration: Unsupported encoding " + e.getMessage(), e);
                            }
                            throw new XMLParseException("Found illegal character in XML header: '" + (char)c + "'").setSource(source, pos);
                        }
                        try {
                            s = new String(header, 0, pos, ENCODING_UTF_8);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new XMLParseException("Error parsing XML declaration: Unsupported encoding " + e.getMessage(), e);
                        }
                        Matcher matcher = VERSION_PATTERN.matcher(s);
                        if (!matcher.find()) {
                            throw new XMLParseException("Missing version in XML declaration").setSource(new XMLStringSource(s), pos);
                        }
                        String pattern = "encoding=";
                        pos = s.indexOf(pattern);
                        if (pos != -1) {
                            int pos2;
                            char c2 = s.charAt(pos += pattern.length());
                            if (c2 != '\'' && c2 != '\"') {
                                throw new XMLParseException("Missing opening quote for encoding").setSource(new XMLStringSource(s), pos);
                            }
                            if ((pos2 = s.indexOf(c2, ++pos)) == -1) {
                                throw new XMLParseException("Missing closing quote for encoding").setSource(new XMLStringSource(s), pos);
                            }
                            encoding = s.substring(pos, pos2);
                            encodingOffset = pos;
                        }
                    }
                }
            }
        }
        JoinedInputStream jin = new JoinedInputStream().add(new ByteArrayInputStream(header, skip, headerLength - skip)).add(this.in);
        this.setXmlEncoding(encoding);
        try {
            this.delegate = new InputStreamReader((InputStream)jin, this.javaEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLParseException("Error parsing XML declaration: Unsupported encoding '" + this.javaEncoding + "'", e).setSource(new XMLStringSource(s), encodingOffset);
        }
    }

    public String getXmlEncoding() {
        this.determineEncoding();
        return this.xmlEncoding;
    }

    public void setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
        this.javaEncoding = ENCODING_MAP.get(xmlEncoding);
        if (this.javaEncoding == null) {
            this.javaEncoding = xmlEncoding;
        }
        if (JAVA_TO_XML_ENCODING_MAP.containsKey(this.xmlEncoding)) {
            this.xmlEncoding = JAVA_TO_XML_ENCODING_MAP.get(this.xmlEncoding);
        }
    }

    public String getJavaEncoding() {
        this.determineEncoding();
        return this.javaEncoding;
    }

    public void close() throws IOException {
        if (this.delegate == null) {
            this.in.close();
        } else {
            this.delegate.close();
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        this.determineEncoding();
        return this.delegate.read(cbuf, off, len);
    }

    static {
        ENCODING_MAP.put("Utf-8", ENCODING_UTF_8);
        ENCODING_MAP.put("utf-8", ENCODING_UTF_8);
        ENCODING_MAP.put("Latin-1", "ISO-8859-1");
        JAVA_TO_XML_ENCODING_MAP = new HashMap<String, String>();
        JAVA_TO_XML_ENCODING_MAP.put("UnicodeBig", "UTF-16");
        JAVA_TO_XML_ENCODING_MAP.put("UnicodeLittle", "UTF-16");
        VERSION_PATTERN = Pattern.compile("\\bversion\\s*=\\s*[\"'][0-9.]+[\"']");
    }
}

