/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.pmml;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.pmml.PMMLConstants;
import org.kie.internal.pmml.PMMLImplementationsUtil;

public class PMMLImplementationsUtilTest {
    @Test
    public void testGetPMMLConstantsBothPresentWithSysProp() {
        System.setProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.NEW.getName());
        PMMLConstants retrieved = PMMLImplementationsUtil.getPMMLConstants((boolean)true, (boolean)true);
        Assert.assertEquals((Object)PMMLConstants.NEW, (Object)retrieved);
        System.setProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.LEGACY.getName());
        retrieved = PMMLImplementationsUtil.getPMMLConstants((boolean)true, (boolean)true);
        Assert.assertEquals((Object)PMMLConstants.LEGACY, (Object)retrieved);
    }

    @Test
    public void testGetPMMLConstantsPathLegacyPresentWithSysProp() {
        System.setProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.LEGACY.getName());
        PMMLConstants retrieved = PMMLImplementationsUtil.getPMMLConstants((boolean)true, (boolean)false);
        Assert.assertEquals((Object)PMMLConstants.LEGACY, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPMMLConstantsPathLegacyPresentWithSysPropWrong() {
        System.setProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.NEW.getName());
        PMMLImplementationsUtil.getPMMLConstants((boolean)true, (boolean)false);
    }

    @Test
    public void testGetPMMLConstantsNewPresentWithSysProp() {
        System.setProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.NEW.getName());
        PMMLConstants retrieved = PMMLImplementationsUtil.getPMMLConstants((boolean)false, (boolean)true);
        Assert.assertEquals((Object)PMMLConstants.NEW, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPMMLConstantsPathNewPresentWithSysPropWrong() {
        System.setProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.LEGACY.getName());
        PMMLImplementationsUtil.getPMMLConstants((boolean)false, (boolean)true);
    }

    @Test
    public void testGetFromClassPathBothPresent() {
        PMMLConstants retrieved = PMMLImplementationsUtil.getFromClassPath((boolean)true, (boolean)true);
        Assert.assertEquals((Object)PMMLConstants.LEGACY, (Object)retrieved);
    }

    @Test
    public void testGetFromClassPathLegacyPresent() {
        PMMLConstants retrieved = PMMLImplementationsUtil.getFromClassPath((boolean)true, (boolean)false);
        Assert.assertEquals((Object)PMMLConstants.LEGACY, (Object)retrieved);
    }

    @Test
    public void testGetFromClassPathNewPresent() {
        PMMLConstants retrieved = PMMLImplementationsUtil.getFromClassPath((boolean)false, (boolean)true);
        Assert.assertEquals((Object)PMMLConstants.NEW, (Object)retrieved);
    }

    @Test
    public void testReturnImplementationLegacyPresent() {
        PMMLConstants retrieved = PMMLImplementationsUtil.returnImplementation((PMMLConstants)PMMLConstants.LEGACY, (boolean)true);
        Assert.assertEquals((Object)PMMLConstants.LEGACY, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReturnImplementationLegacyNotPresent() {
        PMMLImplementationsUtil.returnImplementation((PMMLConstants)PMMLConstants.LEGACY, (boolean)false);
    }

    @Test
    public void testReturnImplementationNewPresent() {
        PMMLConstants retrieved = PMMLImplementationsUtil.returnImplementation((PMMLConstants)PMMLConstants.NEW, (boolean)true);
        Assert.assertEquals((Object)PMMLConstants.NEW, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReturnImplementationNewNotPresent() {
        PMMLImplementationsUtil.returnImplementation((PMMLConstants)PMMLConstants.NEW, (boolean)false);
    }
}

