/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager.deploy;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbMarshalingTest {
    private static final Logger logger = LoggerFactory.getLogger(JaxbMarshalingTest.class);
    private Class<?>[] jaxbClasses = new Class[]{DeploymentDescriptorImpl.class};

    @Test
    public void testJaxbDeploymentDescriptorSerialization() throws Exception {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl();
        descriptor.getBuilder().addTaskEventListener(new ObjectModel("org.jbpm.task.Listener", new Object[]{"test", "another"}));
        String output = this.convertJaxbObjectToString(descriptor);
        logger.debug(output);
        Assert.assertNotNull((Object)output);
    }

    public String convertJaxbObjectToString(Object object) throws JAXBException {
        Marshaller marshaller = JAXBContext.newInstance((Class[])this.jaxbClasses).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal(object, (Writer)stringWriter);
        String output = stringWriter.toString();
        return output;
    }
}

