/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager.deploy;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorMerger;

public class DeploymentDescriptorMergerTest {
    @Test
    public void testDeploymentDesciptorMergeOverrideAll() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assertions.assertThat((Object)primary).isNotNull();
        Assertions.assertThat((String)primary.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)primary.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)primary.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)primary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)primary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)primary.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)primary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)primary.getLimitSerializationClasses()).isTrue();
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit").auditPersistenceUnit("my.custom.unit2").setLimitSerializationClasses(Boolean.valueOf(false));
        Assertions.assertThat((Object)secondary).isNotNull();
        Assertions.assertThat((String)secondary.getPersistenceUnit()).isEqualTo("my.custom.unit");
        Assertions.assertThat((String)secondary.getAuditPersistenceUnit()).isEqualTo("my.custom.unit2");
        Assertions.assertThat((Comparable)secondary.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)secondary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)secondary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)secondary.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)secondary.getLimitSerializationClasses()).isFalse();
        DeploymentDescriptor outcome = DeploymentDescriptorMerger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, (MergeMode)MergeMode.OVERRIDE_ALL);
        Assertions.assertThat((Object)outcome).isNotNull();
        Assertions.assertThat((String)outcome.getPersistenceUnit()).isEqualTo("my.custom.unit");
        Assertions.assertThat((String)outcome.getAuditPersistenceUnit()).isEqualTo("my.custom.unit2");
        Assertions.assertThat((Comparable)outcome.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)outcome.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)outcome.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)outcome.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)outcome.getLimitSerializationClasses()).isFalse();
    }

    @Test
    public void testDeploymentDesciptorMergeKeepAll() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assertions.assertThat((Object)primary).isNotNull();
        Assertions.assertThat((String)primary.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)primary.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)primary.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)primary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)primary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)primary.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)primary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)primary.getLimitSerializationClasses()).isTrue();
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit").auditPersistenceUnit("my.custom.unit2").setLimitSerializationClasses(Boolean.valueOf(false));
        Assertions.assertThat((Object)secondary).isNotNull();
        Assertions.assertThat((String)secondary.getPersistenceUnit()).isEqualTo("my.custom.unit");
        Assertions.assertThat((String)secondary.getAuditPersistenceUnit()).isEqualTo("my.custom.unit2");
        Assertions.assertThat((Comparable)secondary.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)secondary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)secondary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)secondary.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)secondary.getLimitSerializationClasses()).isFalse();
        DeploymentDescriptor outcome = DeploymentDescriptorMerger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, (MergeMode)MergeMode.KEEP_ALL);
        Assertions.assertThat((Object)outcome).isNotNull();
        Assertions.assertThat((String)outcome.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)outcome.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)outcome.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)outcome.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)outcome.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)outcome.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)outcome.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)outcome.getLimitSerializationClasses()).isTrue();
    }

    @Test
    public void testDeploymentDesciptorMergeOverrideEmpty() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assertions.assertThat((Object)primary).isNotNull();
        Assertions.assertThat((String)primary.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)primary.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)primary.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)primary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)primary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)primary.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)primary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)primary.getLimitSerializationClasses()).isTrue();
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("");
        Assertions.assertThat((Object)secondary).isNotNull();
        Assertions.assertThat((String)secondary.getPersistenceUnit()).isEqualTo(null);
        Assertions.assertThat((String)secondary.getAuditPersistenceUnit()).isEqualTo("");
        Assertions.assertThat((Comparable)secondary.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)secondary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)secondary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)secondary.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getWorkItemHandlers().size()).isEqualTo(0);
        secondary.setLimitSerializationClasses(null);
        Assertions.assertThat((Boolean)secondary.getLimitSerializationClasses()).isNull();
        DeploymentDescriptor outcome = DeploymentDescriptorMerger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, (MergeMode)MergeMode.OVERRIDE_EMPTY);
        Assertions.assertThat((Object)outcome).isNotNull();
        Assertions.assertThat((String)outcome.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)outcome.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)outcome.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)outcome.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)outcome.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)outcome.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)outcome.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)outcome.getLimitSerializationClasses()).isTrue();
    }

    @Test
    public void testDeploymentDesciptorMergeMergeCollections() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(true));
        Assertions.assertThat((Object)primary).isNotNull();
        Assertions.assertThat((String)primary.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)primary.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)primary.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)primary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)primary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)primary.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)primary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)primary.getLimitSerializationClasses()).isTrue();
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("").addMarshalingStrategy(new ObjectModel("org.jbpm.test.AnotherCustomStrategy", new Object[]{"param2"})).setLimitSerializationClasses(Boolean.valueOf(false));
        Assertions.assertThat((Object)secondary).isNotNull();
        Assertions.assertThat((String)secondary.getPersistenceUnit()).isEqualTo(null);
        Assertions.assertThat((String)secondary.getAuditPersistenceUnit()).isEqualTo("");
        Assertions.assertThat((Comparable)secondary.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)secondary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)secondary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)secondary.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)secondary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)secondary.getLimitSerializationClasses()).isFalse();
        DeploymentDescriptor outcome = DeploymentDescriptorMerger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, (MergeMode)MergeMode.MERGE_COLLECTIONS);
        Assertions.assertThat((Object)outcome).isNotNull();
        Assertions.assertThat((String)outcome.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)outcome.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)outcome.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)outcome.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)outcome.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)outcome.getMarshallingStrategies().size()).isEqualTo(2);
        Assertions.assertThat((int)outcome.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getWorkItemHandlers().size()).isEqualTo(0);
        Assertions.assertThat((Boolean)outcome.getLimitSerializationClasses()).isFalse();
    }

    @Test
    public void testDeploymentDesciptorMergeHierarchy() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"}));
        Assertions.assertThat((Object)primary).isNotNull();
        Assertions.assertThat((String)primary.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)primary.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)primary.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)primary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)primary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)primary.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)primary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getWorkItemHandlers().size()).isEqualTo(0);
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.NONE).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit").auditPersistenceUnit("my.custom.unit2");
        Assertions.assertThat((Object)secondary).isNotNull();
        Assertions.assertThat((String)secondary.getPersistenceUnit()).isEqualTo("my.custom.unit");
        Assertions.assertThat((String)secondary.getAuditPersistenceUnit()).isEqualTo("my.custom.unit2");
        Assertions.assertThat((Comparable)secondary.getAuditMode()).isEqualTo((Object)AuditMode.NONE);
        Assertions.assertThat((Comparable)secondary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)secondary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)secondary.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getWorkItemHandlers().size()).isEqualTo(0);
        DeploymentDescriptorImpl third = new DeploymentDescriptorImpl("org.jbpm.domain");
        third.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit("my.custom.unit2").auditPersistenceUnit("my.custom.altered").runtimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE).addEnvironmentEntry(new NamedObjectModel("IS_JTA", "java.lang.Boolean", new Object[]{"false"}));
        Assertions.assertThat((Object)third).isNotNull();
        Assertions.assertThat((String)third.getPersistenceUnit()).isEqualTo("my.custom.unit2");
        Assertions.assertThat((String)third.getAuditPersistenceUnit()).isEqualTo("my.custom.altered");
        Assertions.assertThat((Comparable)third.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)third.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)third.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.PER_PROCESS_INSTANCE);
        Assertions.assertThat((int)third.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)third.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)third.getEnvironmentEntries().size()).isEqualTo(1);
        Assertions.assertThat((int)third.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)third.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)third.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)third.getWorkItemHandlers().size()).isEqualTo(0);
        ArrayList<DeploymentDescriptorImpl> hierarchy = new ArrayList<DeploymentDescriptorImpl>();
        hierarchy.add(third);
        hierarchy.add(secondary);
        hierarchy.add(primary);
        DeploymentDescriptor outcome = DeploymentDescriptorMerger.merge(hierarchy, (MergeMode)MergeMode.MERGE_COLLECTIONS);
        Assertions.assertThat((Object)outcome).isNotNull();
        Assertions.assertThat((String)outcome.getPersistenceUnit()).isEqualTo("my.custom.unit2");
        Assertions.assertThat((String)outcome.getAuditPersistenceUnit()).isEqualTo("my.custom.altered");
        Assertions.assertThat((Comparable)outcome.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)outcome.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)outcome.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.PER_PROCESS_INSTANCE);
        Assertions.assertThat((int)outcome.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)outcome.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEnvironmentEntries().size()).isEqualTo(1);
        Assertions.assertThat((int)outcome.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getWorkItemHandlers().size()).isEqualTo(0);
    }

    @Test
    public void testDeploymentDesciptorMergeMergeCollectionsAvoidDuplicates() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"}));
        Assertions.assertThat((Object)primary).isNotNull();
        Assertions.assertThat((String)primary.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)primary.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)primary.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)primary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)primary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)primary.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)primary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getWorkItemHandlers().size()).isEqualTo(0);
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("").addMarshalingStrategy(new ObjectModel("org.jbpm.test.CustomStrategy", new Object[]{"param2"}));
        Assertions.assertThat((Object)secondary).isNotNull();
        Assertions.assertThat((String)secondary.getPersistenceUnit()).isEqualTo(null);
        Assertions.assertThat((String)secondary.getAuditPersistenceUnit()).isEqualTo("");
        Assertions.assertThat((Comparable)secondary.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)secondary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)secondary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)secondary.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)secondary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getWorkItemHandlers().size()).isEqualTo(0);
        DeploymentDescriptor outcome = DeploymentDescriptorMerger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, (MergeMode)MergeMode.MERGE_COLLECTIONS);
        Assertions.assertThat((Object)outcome).isNotNull();
        Assertions.assertThat((String)outcome.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)outcome.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)outcome.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)outcome.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)outcome.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)outcome.getMarshallingStrategies().size()).isEqualTo(1);
        Assertions.assertThat((int)outcome.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getWorkItemHandlers().size()).isEqualTo(0);
    }

    @Test
    public void testDeploymentDesciptorMergeMergeCollectionsAvoidDuplicatesNamedObject() {
        DeploymentDescriptorImpl primary = new DeploymentDescriptorImpl("org.jbpm.domain");
        primary.getBuilder().addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()", new Object[0]));
        Assertions.assertThat((Object)primary).isNotNull();
        Assertions.assertThat((String)primary.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)primary.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)primary.getAuditMode()).isEqualTo((Object)AuditMode.JPA);
        Assertions.assertThat((Comparable)primary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)primary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)primary.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)primary.getWorkItemHandlers().size()).isEqualTo(1);
        DeploymentDescriptorImpl secondary = new DeploymentDescriptorImpl("org.jbpm.domain");
        secondary.getBuilder().auditMode(AuditMode.JMS).persistenceMode(PersistenceMode.JPA).persistenceUnit(null).auditPersistenceUnit("").addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.CustomSystemOutWorkItemHandler()", new Object[0]));
        Assertions.assertThat((Object)secondary).isNotNull();
        Assertions.assertThat((String)secondary.getPersistenceUnit()).isEqualTo(null);
        Assertions.assertThat((String)secondary.getAuditPersistenceUnit()).isEqualTo("");
        Assertions.assertThat((Comparable)secondary.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)secondary.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)secondary.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)secondary.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)secondary.getWorkItemHandlers().size()).isEqualTo(1);
        DeploymentDescriptor outcome = DeploymentDescriptorMerger.merge((DeploymentDescriptor)primary, (DeploymentDescriptor)secondary, (MergeMode)MergeMode.MERGE_COLLECTIONS);
        Assertions.assertThat((Object)outcome).isNotNull();
        Assertions.assertThat((String)outcome.getPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((String)outcome.getAuditPersistenceUnit()).isEqualTo("org.jbpm.domain");
        Assertions.assertThat((Comparable)outcome.getAuditMode()).isEqualTo((Object)AuditMode.JMS);
        Assertions.assertThat((Comparable)outcome.getPersistenceMode()).isEqualTo((Object)PersistenceMode.JPA);
        Assertions.assertThat((Comparable)outcome.getRuntimeStrategy()).isEqualTo((Object)RuntimeStrategy.SINGLETON);
        Assertions.assertThat((int)outcome.getMarshallingStrategies().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getConfiguration().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEnvironmentEntries().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getGlobals().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getTaskEventListeners().size()).isEqualTo(0);
        Assertions.assertThat((int)outcome.getWorkItemHandlers().size()).isEqualTo(1);
        NamedObjectModel model = (NamedObjectModel)outcome.getWorkItemHandlers().get(0);
        Assertions.assertThat((String)model.getName()).isEqualTo("Log");
        Assertions.assertThat((String)model.getIdentifier()).isEqualTo("new org.jbpm.process.instance.impl.demo.CustomSystemOutWorkItemHandler()");
    }
}

