/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest.util;

import java.util.concurrent.TimeUnit;

public class TimerUtils {
    private static final long SLEEP_PRECISION = Long.valueOf(System.getProperty("TIMER_SLEEP_PRECISION", "50000"));
    private static final long SPIN_YIELD_PRECISION = Long.valueOf(System.getProperty("TIMER_YIELD_PRECISION", "30000"));

    private TimerUtils() {
    }

    public static void sleepMillis(long duration) throws InterruptedException {
        TimerUtils.sleepNanos(TimeUnit.MILLISECONDS.toNanos(duration));
    }

    public static void sleepNanos(long nanoDuration) throws InterruptedException {
        long end = System.nanoTime() + nanoDuration;
        long timeLeft = nanoDuration;
        do {
            if (timeLeft > SLEEP_PRECISION) {
                Thread.sleep(1L);
                continue;
            }
            if (timeLeft <= SPIN_YIELD_PRECISION) continue;
            Thread.yield();
        } while ((timeLeft = end - System.nanoTime()) > 0L);
    }
}

