/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest.kieserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.junit.Assert;
import org.kie.api.command.Command;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseKieServerClientKarafIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(BaseKieServerClientKarafIntegrationTest.class);
    protected String serverUrl = System.getProperty("org.kie.server.itest.server.url", "http://localhost:8080/kie-server/services/rest/server");
    protected String user = System.getProperty("org.kie.server.itest.user", "kieserver");
    protected String password = System.getProperty("org.kie.server.itest.password", "kieserver@pwd1");
    protected String containerId = System.getProperty("org.kie.server.itest.container", "evaluationproject");
    protected String processId = System.getProperty("org.kie.server.itest.process", "evaluation");

    protected void testListContainers(MarshallingFormat marshallingFormat) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)this.serverUrl, (String)this.user, (String)this.password);
        configuration.setMarshallingFormat(marshallingFormat);
        KieServicesClient kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration, (ClassLoader)this.getClass().getClassLoader());
        ServiceResponse containersResponse = kieServicesClient.listContainers();
        Assert.assertNotNull((Object)containersResponse);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.SUCCESS, (Object)containersResponse.getType());
        Assert.assertNotNull((Object)containersResponse.getResult());
        List containers = ((KieContainerResourceList)containersResponse.getResult()).getContainers();
        Assert.assertNotNull((Object)containers);
        logger.info("Found containers = " + containers);
        Assert.assertTrue((containers.size() > 0 ? 1 : 0) != 0);
    }

    protected void testCompleteInteractionWithKieServer(MarshallingFormat marshallingFormat) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)this.serverUrl, (String)this.user, (String)this.password);
        configuration.setMarshallingFormat(marshallingFormat);
        KieServicesClient kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration, (ClassLoader)this.getClass().getClassLoader());
        QueryServicesClient queryClient = (QueryServicesClient)kieServicesClient.getServicesClient(QueryServicesClient.class);
        List processes = queryClient.findProcesses(Integer.valueOf(0), Integer.valueOf(10));
        System.out.println("\t######### Available processes" + processes);
        ProcessServicesClient processClient = (ProcessServicesClient)kieServicesClient.getServicesClient(ProcessServicesClient.class);
        ProcessDefinition definition = processClient.getProcessDefinition(this.containerId, this.processId);
        System.out.println("\t######### Definition details: " + definition);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", this.user);
        Long processInstanceId = processClient.startProcess(this.containerId, this.processId, params);
        System.out.println("\t######### Process instance id: " + processInstanceId);
        UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
        List tasks = taskClient.findTasks(this.user, Integer.valueOf(0), Integer.valueOf(10));
        System.out.println("\t######### Tasks: " + tasks);
        Long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskClient.startTask(this.containerId, taskId, this.user);
        taskClient.completeTask(this.containerId, taskId, this.user, null);
        ArrayList<Object> commands = new ArrayList<Object>();
        BatchExecutionCommandImpl executionCommand = new BatchExecutionCommandImpl(commands);
        executionCommand.setLookup("defaultKieSession");
        InsertObjectCommand insertObjectCommand = new InsertObjectCommand();
        insertObjectCommand.setOutIdentifier("person");
        insertObjectCommand.setObject((Object)"john");
        FireAllRulesCommand fireAllRulesCommand = new FireAllRulesCommand();
        commands.add(insertObjectCommand);
        commands.add(fireAllRulesCommand);
        RuleServicesClient ruleClient = (RuleServicesClient)kieServicesClient.getServicesClient(RuleServicesClient.class);
        ruleClient.executeCommands(this.containerId, (Command)executionCommand);
        System.out.println("\t######### Rules executed");
        processClient.abortProcessInstance(this.containerId, processInstanceId);
        ProcessInstance processInstance = queryClient.findProcessInstanceById(processInstanceId);
        System.out.println("\t######### ProcessInstance: " + processInstance);
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{BaseKieServerClientKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), BaseKieServerClientKarafIntegrationTest.loadKieFeatures("kie-server-client")};
    }
}

