/*
 * Decompiled with CFR 0.152.
 */
package org.kie.example.api.kiemavenexample;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.runtime.KieSession;
import org.kie.example.api.kiemavenexample.Message;

public class KieMavenPluginFromFSExampleTest {
    @Test
    public void testGo() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.go(ps);
        ps.close();
        String actual = new String(baos.toByteArray());
        if (File.separatorChar == '\\') {
            actual = actual.replaceAll("\r\n", "\n");
        }
        String expected = "Dave: Hello, HAL. Do you read me, HAL?\nHAL: Dave. I read you.\n";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void go(PrintStream out) {
        String currentFolder = null;
        try {
            currentFolder = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File rootFolder = null;
        rootFolder = currentFolder.endsWith("-integration") ? new File("kie-examples-api/kie-maven-example") : (currentFolder.endsWith("drools-examples-api") ? new File("kie-maven-example") : new File("."));
        KieServices ks = KieServices.Factory.get();
        KieBuilder kieBuilder = ks.newKieBuilder(rootFolder).buildAll();
        KieSession kSession = ks.newKieContainer(kieBuilder.getKieModule().getReleaseId()).newKieSession();
        kSession.setGlobal("out", (Object)out);
        kSession.insert((Object)new Message("Dave", "Hello, HAL. Do you read me, HAL?"));
        kSession.fireAllRules();
    }
}

