/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.internal.io.ResourceFactory;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.CompilerHelper;
import org.kie.maven.plugin.DiskResourceStore;
import org.kie.maven.plugin.ExecModelMode;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class BuildMojo
extends AbstractKieMojo {
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="src/main/resources")
    private File sourceFolder;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=false, defaultValue="no")
    private String usesPMML;
    @Inject
    private PlexusContainer container;
    @Parameter(property="generateModel", defaultValue="no")
    private String generateModel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!ExecModelMode.shouldGenerateModel(this.generateModel)) {
            this.buildDrl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDrl() throws MojoFailureException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<ZipKieModule> kmoduleDeps = new ArrayList<ZipKieModule>();
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.project.getCompileClasspathElements()) {
                urls.add(new File(element).toURI().toURL());
            }
            this.project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Object artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
                KieModuleModel depModel = this.getDependencyKieModel(file);
                if (depModel == null) continue;
                ReleaseIdImpl releaseIdImpl = new ReleaseIdImpl(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                kmoduleDeps.add(new ZipKieModule((ReleaseId)releaseIdImpl, depModel, file));
            }
            urls.add(this.outputDirectory.toURI().toURL());
            URLClassLoader projectClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(projectClassLoader);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        KieServices ks = KieServices.Factory.get();
        try {
            List list;
            this.setSystemProperties(this.properties);
            KieFileSystem kfs = ks.newKieFileSystem();
            for (File file : this.getResourceFiles(this.sourceFolder)) {
                if (file.getPath().contains("META-INF")) continue;
                kfs.write(ResourceFactory.newFileResource((File)file));
            }
            KieBuilderImpl kieBuilder = new KieBuilderImpl(kfs);
            InternalKieModule kModule = (InternalKieModule)kieBuilder.getKieModule();
            for (InternalKieModule internalKieModule : kmoduleDeps) {
                kModule.addKieDependency(internalKieModule);
            }
            kieBuilder.buildAll();
            ResultsImpl messages = (ResultsImpl)kieBuilder.getResults();
            List list2 = list = messages != null ? messages.filterMessages(new Message.Level[]{Message.Level.ERROR}) : Collections.emptyList();
            if (this.container != null) {
                Map<String, Object> kieMap = this.getKieMap();
                if (!kieMap.isEmpty()) {
                    CompilerHelper helper = new CompilerHelper();
                    helper.share(kieMap, kModule, this.getLog());
                } else {
                    this.getLog().info((CharSequence)"Kie Map empty");
                }
            } else {
                new KieMetaInfoBuilder(kModule).writeKieModuleMetaInfo((ResourceStore)new DiskResourceStore(this.outputDirectory));
            }
            if (!list.isEmpty()) {
                for (Message error : list) {
                    this.getLog().error((CharSequence)error.toString());
                }
                throw new MojoFailureException("Build failed!");
            }
            this.writeClassFiles(kModule);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.getLog().info((CharSequence)"KieModule successfully built!");
    }

    private List<File> getResourceFiles(File parent) {
        ArrayList<File> files = new ArrayList<File>();
        if (parent.isDirectory()) {
            File[] children;
            for (File child : children = parent.listFiles()) {
                if (child.isDirectory()) {
                    List<File> childsFiles = this.getResourceFiles(child);
                    if (childsFiles == null || childsFiles.isEmpty()) continue;
                    files.addAll(childsFiles);
                    continue;
                }
                files.add(child);
            }
        }
        return files;
    }

    private void writeClassFiles(InternalKieModule kModule) throws MojoFailureException {
        MemoryFileSystem mfs = ((MemoryKieModule)kModule).getMemoryFileSystem();
        kModule.getFileNames().stream().filter(name -> name.endsWith(".class")).forEach(fileName -> {
            try {
                this.saveFile(mfs, (String)fileName);
            }
            catch (MojoFailureException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void saveFile(MemoryFileSystem mfs, String fileName) throws MojoFailureException {
        MemoryFile memFile = (MemoryFile)mfs.getFile(fileName);
        Path path = Paths.get(this.outputDirectory.getPath(), memFile.getPath().toPortableString());
        try {
            Files.deleteIfExists(path);
            Files.createDirectories(path, new FileAttribute[0]);
            Files.copy(memFile.getContents(), path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iox) {
            iox.printStackTrace();
            throw new MojoFailureException("Unable to write file", (Throwable)iox);
        }
    }

    private Map<String, Object> getKieMap() {
        try {
            Map kieMap = (Map)this.container.lookup(Map.class, "java.util.HashMap", "kieMap");
            return Optional.ofNullable(kieMap).orElse(Collections.emptyMap());
        }
        catch (ComponentLookupException cle) {
            this.getLog().info((CharSequence)"kieMap not present");
            return Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KieModuleModel getDependencyKieModel(File jar) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jar);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/kmodule.xml");
            if (zipEntry != null) {
                KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
                KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
                KieModuleModel kieModuleModel2 = kieModuleModel;
                return kieModuleModel2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

