/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.modelcompiler.builder.CanonicalModelKieProject;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.ModelWriter;
import org.drools.modelcompiler.builder.PackageModel;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.ExecModelMode;

@Mojo(name="mvelValidator", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class MvelValidatorMojo
extends AbstractKieMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(property="generateModel", defaultValue="no")
    private String generateModel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (ExecModelMode.shouldValidateMVEL(this.generateModel)) {
            this.getLog().info((CharSequence)"Starting MVEL Validation");
            this.validateMVEL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateMVEL() throws MojoExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        KieServices ks = KieServices.Factory.get();
        try {
            KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(this.projectDir);
            kieBuilder.buildAll(ExecutableModelMavenPluginKieProject::new, s -> !s.contains("src/test/java"));
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static class ExecutableModelMavenPluginKieProject
    extends CanonicalModelKieProject {
        public ExecutableModelMavenPluginKieProject(InternalKieModule kieModule, ClassLoader classLoader) {
            super(true, kieModule, classLoader);
        }

        public void writeProjectOutput(MemoryFileSystem trgMfs, ResultsImpl messages) {
            MemoryFileSystem srcMfs = new MemoryFileSystem();
            ModelWriter modelWriter = new ModelWriter();
            for (ModelBuilderImpl modelBuilder : this.modelBuilders) {
                ModelWriter.Result result = modelWriter.writeModel(srcMfs, (Collection)modelBuilder.getPackageModels());
                String[] sources = result.getSources();
                if (sources.length == 0) continue;
                JavaParserCompiler.getCompiler().compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClassLoader());
                for (PackageModel pm : modelBuilder.getPackageModels()) {
                    pm.validateConsequence(this.getClassLoader(), trgMfs, messages);
                }
                List errorMessages = messages.getMessages(new Message.Level[]{Message.Level.ERROR});
                if (errorMessages.isEmpty()) continue;
                String errorMessagesString = errorMessages.stream().map(Object::toString).collect(Collectors.joining("\n"));
                throw new RuntimeException((Throwable)new MojoExecutionException(errorMessagesString));
            }
        }
    }
}

