/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;

public class ArtifactItem {
    private String groupId;
    private String artifactId;
    private String version = null;
    private String type = "jar";
    private String classifier;
    private Artifact artifact;

    public ArtifactItem() {
    }

    public ArtifactItem(Artifact artifact) {
        this.setArtifact(artifact);
        this.setArtifactId(artifact.getArtifactId());
        this.setClassifier(artifact.getClassifier());
        this.setGroupId(artifact.getGroupId());
        this.setType(artifact.getType());
        this.setVersion(artifact.getVersion());
    }

    private String filterEmptyString(String in) {
        if ("".equals(in)) {
            return null;
        }
        return in;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String theArtifact) {
        this.artifactId = this.filterEmptyString(theArtifact);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = this.filterEmptyString(groupId);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = this.filterEmptyString(type);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = this.filterEmptyString(version);
    }

    public String getBaseVersion() {
        return ArtifactUtils.toSnapshotVersion((String)this.version);
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = this.filterEmptyString(classifier);
    }

    public String toString() {
        if (this.classifier == null) {
            return this.groupId + ":" + this.artifactId + ":" + Objects.toString(this.version, "?") + ":" + this.type;
        }
        return this.groupId + ":" + this.artifactId + ":" + this.classifier + ":" + Objects.toString(this.version, "?") + ":" + this.type;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }
}

