/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.io.impl.FileSystemResource;
import org.drools.modelcompiler.builder.GeneratedFile;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;
import org.kie.api.pmml.PMMLConstants;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.ExecModelMode;
import org.kie.maven.plugin.GenerateCodeUtil;
import org.kie.maven.plugin.PMMLResource;
import org.kie.maven.plugin.ProjectPomModel;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.evaluator.assembler.service.PMMLCompilerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generatePMMLModel", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class GeneratePMMLModelMojo
extends AbstractKieMojo {
    private static final Logger logger = LoggerFactory.getLogger(GeneratePMMLModelMojo.class);
    private static final String PMML = "pmml";
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.resources}", required=true, readonly=true)
    private List<org.apache.maven.model.Resource> resourcesDirectories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (GeneratePMMLModelMojo.isLegacyInvoked()) {
            this.getLog().warn((CharSequence)("Skipping `generatePMMLModel` because " + PMMLConstants.KIE_PMML_IMPLEMENTATION.getName() + " is " + PMMLConstants.LEGACY.getName()));
            return;
        }
        boolean modelCompilerInClassPath = ExecModelMode.isModelCompilerInClassPath(this.project.getDependencies());
        if (!modelCompilerInClassPath) {
            this.getLog().warn((CharSequence)"Skipping `generatePMMLModel` because you did not provide the required dependency on the project classpath.\nTo enable it for your project, add the `drools-model-compiler` dependency in the `pom.xml` file of your project.\n");
        } else {
            this.generateModel();
        }
    }

    static boolean isLegacyInvoked() {
        String property = System.getProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.NEW.getName());
        return property.equals(PMMLConstants.LEGACY.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModel() throws MojoExecutionException {
        JavaCompilerSettings javaCompilerSettings = GenerateCodeUtil.createJavaCompilerSettings();
        URLClassLoader projectClassLoader = GenerateCodeUtil.getProjectClassLoader(this.project, this.outputDirectory, javaCompilerSettings);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(projectClassLoader);
        try {
            GenerateCodeUtil.compileAndWriteClasses(this.targetDirectory, projectClassLoader, javaCompilerSettings, this.getCompilerType(), this.generateFiles(), this.dumpKieSourcesFolder);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (projectClassLoader != null) {
                try {
                    projectClassLoader.close();
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            }
        }
        this.getLog().info((CharSequence)"PMML model successfully generated");
    }

    private Map<String, String> generateFiles() throws MojoExecutionException {
        List<GeneratedFile> generatedFiles = this.getGeneratedFiles();
        KieServices ks = KieServices.Factory.get();
        KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(this.projectDir);
        kieBuilder.setPomModel((PomModel)new ProjectPomModel(this.mavenSession));
        HashMap<String, String> classNameSourceMap = new HashMap<String, String>();
        for (GeneratedFile generatedFile : generatedFiles) {
            String className = GenerateCodeUtil.toClassName(generatedFile.getPath());
            classNameSourceMap.put(className, new String(generatedFile.getData()));
            this.getLog().info((CharSequence)("Generating " + className));
        }
        return classNameSourceMap;
    }

    private List<GeneratedFile> getGeneratedFiles() throws MojoExecutionException {
        ArrayList<GeneratedFile> toReturn = new ArrayList<GeneratedFile>();
        for (org.apache.maven.model.Resource resourceDirectory : this.resourcesDirectories) {
            File directoryFile = new File(resourceDirectory.getDirectory());
            this.getLog().info((CharSequence)("Looking for PMML models in " + directoryFile.getPath()));
            String errorMessageTemplate = null;
            if (!directoryFile.exists()) {
                errorMessageTemplate = "Resource path %s does not exists";
            } else if (!directoryFile.canRead()) {
                errorMessageTemplate = "Resource path %s is not readable";
            } else if (!directoryFile.isDirectory()) {
                errorMessageTemplate = "Resource path %s is not a directory";
            }
            if (errorMessageTemplate != null) {
                throw new MojoExecutionException(String.format(errorMessageTemplate, resourceDirectory));
            }
            toReturn.addAll(this.getGeneratedFiles(directoryFile));
        }
        if (toReturn.isEmpty()) {
            this.getLog().info((CharSequence)"No PMML Models found.");
        } else {
            this.getLog().info((CharSequence)String.format("Found %s PMML models", toReturn.size()));
        }
        return toReturn;
    }

    private List<GeneratedFile> getGeneratedFiles(File resourceDirectory) throws MojoExecutionException {
        List list;
        block8: {
            ArrayList toReturn = new ArrayList();
            Stream<Path> stream = Files.walk(resourceDirectory.toPath(), Integer.MAX_VALUE, new FileVisitOption[0]).filter(path -> path.toFile().isFile() && path.toString().endsWith(PMML));
            try {
                list = stream.map(Path::toFile).map(FileSystemResource::new).map(this::parseResource).map(this::getGenerateFiles).reduce(toReturn, (previous, toAdd) -> {
                    previous.addAll(toAdd);
                    return previous;
                });
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
            stream.close();
        }
        return list;
    }

    private List<GeneratedFile> getGenerateFiles(PMMLResource pmmlResources) {
        ArrayList<GeneratedFile> toReturn = new ArrayList<GeneratedFile>();
        List<KiePMMLModel> kiepmmlModels = pmmlResources.getKiePmmlModels();
        this.addModels(kiepmmlModels, pmmlResources, toReturn);
        return toReturn;
    }

    private void addModels(List<KiePMMLModel> kiepmmlModels, PMMLResource resource, List<GeneratedFile> generatedFiles) {
        for (KiePMMLModel model : kiepmmlModels) {
            String errorMessage;
            if (model.getName() == null || model.getName().isEmpty()) {
                errorMessage = String.format("Model name should not be empty inside %s", resource.getModelPath());
                throw new RuntimeException(errorMessage);
            }
            if (!(model instanceof HasSourcesMap)) {
                errorMessage = String.format("Expecting HasSourcesMap instance, retrieved %s inside %s", model.getClass().getName(), resource.getModelPath());
                throw new RuntimeException(errorMessage);
            }
            Map sourceMap = ((HasSourcesMap)model).getSourcesMap();
            for (Map.Entry sourceMapEntry : sourceMap.entrySet()) {
                String path = ((String)sourceMapEntry.getKey()).replace('.', File.separatorChar) + ".java";
                generatedFiles.add(new GeneratedFile(GeneratedFile.Type.PMML, path, (String)sourceMapEntry.getValue()));
            }
            Map rulesSourceMap = ((HasSourcesMap)model).getRulesSourcesMap();
            if (rulesSourceMap != null) {
                for (Map.Entry rulesSourceMapEntry : rulesSourceMap.entrySet()) {
                    String path = ((String)rulesSourceMapEntry.getKey()).replace('.', File.separatorChar) + ".java";
                    generatedFiles.add(new GeneratedFile(GeneratedFile.Type.RULE, path, (String)rulesSourceMapEntry.getValue()));
                }
            }
            if (!(model instanceof HasNestedModels)) continue;
            this.addModels(((HasNestedModels)model).getNestedModels(), resource, generatedFiles);
        }
    }

    private PMMLResource parseResource(Resource resource) {
        KnowledgeBaseImpl knowledgeBase = new KnowledgeBaseImpl("PMML", null);
        KnowledgeBuilderImpl kbuilderImpl = new KnowledgeBuilderImpl((InternalKnowledgeBase)knowledgeBase);
        List kiePMMLModels = PMMLCompilerService.getKiePMMLModelsFromResourceWithSources((KnowledgeBuilderImpl)kbuilderImpl, (Resource)resource);
        String modelPath = resource.getSourcePath();
        return new PMMLResource(kiePMMLModels, new File(resource.getSourcePath()).toPath(), modelPath);
    }
}

