/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.WriterFactory;
import org.apache.maven.shared.utils.io.IOUtil;
import org.apache.maven.shared.utils.xml.XmlStreamWriter;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.ArtifactItem;

@Mojo(name="package-dependencies-kjar", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageKjarDependenciesMojo
extends AbstractKieMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter
    private List<ArtifactItem> artifactItems;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File outputFolder;
            if (this.artifactItems == null || this.artifactItems.isEmpty()) {
                this.getLog().info((CharSequence)"Skipping plugin execution");
                return;
            }
            ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
            ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>();
            if (this.pomRemoteRepositories != null) {
                repoList.addAll(this.pomRemoteRepositories);
            }
            if (this.remoteRepositories != null) {
                String[] repos;
                for (String repo : repos = StringUtils.split((String)this.remoteRepositories, (String)",")) {
                    repoList.add(this.parseRepository(repo, always));
                }
            }
            if (!(outputFolder = new File(this.outputDirectory + "/KIE-INF/lib")).exists()) {
                outputFolder.mkdirs();
            }
            this.getLog().info((CharSequence)("Create directory: " + outputFolder));
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            for (ArtifactItem artifactItem : this.artifactItems) {
                Artifact kjar = this.resolveArtifact(this.toArtifactCoordinate(artifactItem), repoList);
                this.getLog().info((CharSequence)("Resolved kjar " + kjar + " dependency"));
                artifacts.add(kjar);
                ProjectBuildingRequest buildingRequest = this.buildMavenRequest(repoList);
                Iterable results = this.dependencyResolver.resolveDependencies(buildingRequest, (DependableCoordinate)this.toDefaultDependableCoordinate(kjar), null);
                for (ArtifactResult result : results) {
                    Artifact kjarDependency = this.resolveArtifact(this.toArtifactCoordinate(result.getArtifact()), repoList);
                    artifacts.add(kjarDependency);
                }
            }
            for (Artifact artifact : artifacts) {
                this.getLog().info((CharSequence)("Copying artifact and creating effective pom: " + artifact));
                this.writeEffectivePom(this.projectBuilder.build(artifact, this.session.getProjectBuildingRequest()).getProject(), new File(outputFolder, this.toFile(artifact)));
                File local = artifact.getFile();
                Files.copy((File)local, (File)new File(outputFolder, local.getName()));
            }
        }
        catch (IOException | ProjectBuildingException | ArtifactResolverException | DependencyResolverException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)e);
        }
    }

    private String toFile(Artifact kjarDependency) {
        return kjarDependency.getArtifactId() + "-" + kjarDependency.getVersion() + ".pom";
    }

    private File writeEffectivePom(MavenProject mavenProject, File output) throws MojoExecutionException {
        Model m = mavenProject.getModel();
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)output);
            new MavenXpp3Writer().write((Writer)writer, m);
            this.getLog().debug((CharSequence)("Written effective pom at:" + output.getAbsolutePath()));
            File file = output;
            return file;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing file: " + e.getMessage(), (Exception)e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private Artifact resolveArtifact(ArtifactCoordinate artifact, List<ArtifactRepository> repoList) throws ArtifactResolverException {
        ProjectBuildingRequest buildingRequest = this.buildMavenRequest(repoList);
        this.getLog().debug((CharSequence)("resolving kjar dependency: " + artifact));
        ArtifactResult artifactResolverResult = this.artifactResolver.resolveArtifact(buildingRequest, artifact);
        Artifact artifactResolved = artifactResolverResult.getArtifact();
        return artifactResolved;
    }

    private ProjectBuildingRequest buildMavenRequest(List<ArtifactRepository> repoList) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        Settings settings = this.session.getSettings();
        this.repositorySystem.injectMirror(repoList, settings.getMirrors());
        this.repositorySystem.injectProxy(repoList, settings.getProxies());
        this.repositorySystem.injectAuthentication(repoList, settings.getServers());
        buildingRequest.setRemoteRepositories(repoList);
        return buildingRequest;
    }

    private ArtifactCoordinate toArtifactCoordinate(Artifact artifact) {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(artifact.getType());
        DefaultArtifactCoordinate gav = new DefaultArtifactCoordinate();
        gav.setGroupId(artifact.getGroupId());
        gav.setArtifactId(artifact.getArtifactId());
        gav.setVersion(artifact.getVersion());
        gav.setClassifier(artifact.getClassifier());
        gav.setExtension(artifactHandler.getExtension());
        return gav;
    }

    private ArtifactCoordinate toArtifactCoordinate(ArtifactItem artifact) {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(artifact.getType());
        DefaultArtifactCoordinate gav = new DefaultArtifactCoordinate();
        gav.setGroupId(artifact.getGroupId());
        gav.setArtifactId(artifact.getArtifactId());
        gav.setVersion(artifact.getVersion());
        gav.setClassifier(artifact.getClassifier());
        gav.setExtension(artifactHandler.getExtension());
        return gav;
    }

    private DefaultDependableCoordinate toDefaultDependableCoordinate(Artifact artifact) {
        DefaultDependableCoordinate gav = new DefaultDependableCoordinate();
        gav.setArtifactId(artifact.getArtifactId());
        gav.setGroupId(artifact.getGroupId());
        gav.setVersion(artifact.getVersion());
        gav.setClassifier(artifact.getClassifier());
        gav.setType(artifact.getType());
        return gav;
    }

    private ArtifactRepository parseRepository(String repo, ArtifactRepositoryPolicy policy) throws MojoFailureException {
        String id = "temp";
        ArtifactRepositoryLayout layout = this.getLayout("default");
        String url = repo;
        if (repo.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)repo, "Invalid syntax for repository: " + repo, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (!StringUtils.isEmpty((String)matcher.group(2))) {
                layout = this.getLayout(matcher.group(2).trim());
            }
            url = matcher.group(3).trim();
        }
        return new MavenArtifactRepository(id, url, layout, policy, policy);
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoFailureException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException((Object)id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }
}

