/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler.jdknative;

import javax.tools.JavaCompiler;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.memorycompiler.KieMemoryCompilerException;
import org.kie.memorycompiler.jdknative.JavaCompilerFinder;
import org.kie.memorycompiler.jdknative.NativeJavaCompiler;

public class NativeJavaCompilerTest {
    @Test
    public void simulateJre() {
        NativeJavaCompiler compiler = new NativeJavaCompiler((JavaCompilerFinder)new NullJavaCompilerFinder());
        Assertions.assertThatExceptionOfType(KieMemoryCompilerException.class).isThrownBy(() -> compiler.compile(null, null, null, null, null));
    }

    @Test
    public void simulateJreWithException() {
        NativeJavaCompiler compiler = new NativeJavaCompiler((JavaCompilerFinder)new ExceptionThrowingJavaCompilerFinder());
        Assertions.assertThatExceptionOfType(KieMemoryCompilerException.class).isThrownBy(() -> compiler.compile(null, null, null, null, null));
    }

    private static class NullJavaCompilerFinder
    implements JavaCompilerFinder {
        private NullJavaCompilerFinder() {
        }

        public JavaCompiler getJavaCompiler() {
            return null;
        }
    }

    private static class ExceptionThrowingJavaCompilerFinder
    implements JavaCompilerFinder {
        private ExceptionThrowingJavaCompilerFinder() {
        }

        public JavaCompiler getJavaCompiler() {
            throw new RuntimeException("Test exception");
        }
    }
}

