/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.memorycompiler.KieMemoryCompilerException;

public class KieMemoryCompilerTest {
    private static final String EXAMPLE_CLASS = "package org.kie.memorycompiler;\n\npublic class ExampleClass {\n\n    public int sum(Integer a, Integer b){\n        return a + b;\n    }\n}";
    private static final String WARNING_CLASS = "package org.kie.memorycompiler;\n\npublic class WarningClass {\n\n    @Deprecated    public int minusDeprecated(Integer a, Integer b){\n        return a - b;\n    }\n    public int triggerWarning() {\n        return minusDeprecated(8, 4);\n    }\n}";

    @Test
    public void compileAndLoadClass() throws Exception {
        Map<String, String> source = Collections.singletonMap("org.kie.memorycompiler.ExampleClass", EXAMPLE_CLASS);
        Map compiled = KieMemoryCompiler.compile(source, (ClassLoader)this.getClass().getClassLoader());
        Class exampleClazz = (Class)compiled.get("org.kie.memorycompiler.ExampleClass");
        Assert.assertThat((Object)exampleClazz, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Object instance = exampleClazz.getDeclaredConstructors()[0].newInstance(new Object[0]);
        Method sumMethod = exampleClazz.getMethod("sum", Integer.class, Integer.class);
        Object result = sumMethod.invoke(instance, 2, 3);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)5));
    }

    @Test(expected=KieMemoryCompilerException.class)
    public void invalidClass() {
        Map<String, String> source = Collections.singletonMap("org.kie.memorycompiler.InvalidJavaClass", "Invalid Java Code");
        KieMemoryCompiler.compile(source, (ClassLoader)this.getClass().getClassLoader());
    }

    @Test
    public void doNotFailOnWarning() throws Exception {
        Map<String, String> source = Collections.singletonMap("org.kie.memorycompiler.WarningClass", WARNING_CLASS);
        Map compiled = KieMemoryCompiler.compile(source, (ClassLoader)this.getClass().getClassLoader());
        Class exampleClazz = (Class)compiled.get("org.kie.memorycompiler.WarningClass");
        Assert.assertThat((Object)exampleClazz, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Object instance = exampleClazz.getDeclaredConstructors()[0].newInstance(new Object[0]);
        Method sumMethod = exampleClazz.getMethod("triggerWarning", new Class[0]);
        Object result = sumMethod.invoke(instance, new Object[0]);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)4));
    }
}

