/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.kie.memorycompiler.KieMemoryCompilerClassLoader;
import org.kie.memorycompiler.KieMemoryCompilerException;
import org.kie.memorycompiler.KieMemoryCompilerFileManager;
import org.kie.memorycompiler.KieMemoryCompilerSourceCode;

public class KieMemoryCompiler {
    private static final JavaCompiler JAVA_COMPILER = ToolProvider.getSystemJavaCompiler();
    private static final List<String> OPTIONS = Arrays.asList("-source", "1.8", "-target", "1.8", "-encoding", "UTF-8");

    private KieMemoryCompiler() {
    }

    public static Map<String, Class<?>> compile(Map<String, String> classNameSourceMap, ClassLoader classLoader) {
        Map<String, KieMemoryCompilerSourceCode> sourceCodes = classNameSourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new KieMemoryCompilerSourceCode((String)entry.getKey(), (String)entry.getValue())));
        KieMemoryCompilerClassLoader kieMemoryCompilerClassLoader = new KieMemoryCompilerClassLoader(classLoader);
        DiagnosticCollector collector = new DiagnosticCollector();
        KieMemoryCompilerFileManager fileManager = new KieMemoryCompilerFileManager(JAVA_COMPILER.getStandardFileManager(null, null, null), kieMemoryCompilerClassLoader);
        JavaCompiler.CompilationTask task = JAVA_COMPILER.getTask(null, fileManager, collector, OPTIONS, null, sourceCodes.values());
        boolean result = task.call();
        if (!result || !collector.getDiagnostics().isEmpty()) {
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("Compilation failed");
            for (Diagnostic diagnostic : collector.getDiagnostics()) {
                errorBuilder.append("\r\n");
                errorBuilder.append((Object)diagnostic.getKind());
                errorBuilder.append("; line: ");
                errorBuilder.append(diagnostic.getLineNumber());
                errorBuilder.append("; ");
                errorBuilder.append(diagnostic.getMessage(Locale.US));
            }
            throw new KieMemoryCompilerException(errorBuilder.toString());
        }
        HashMap toReturn = new HashMap();
        for (String className : sourceCodes.keySet()) {
            try {
                toReturn.put(className, kieMemoryCompilerClassLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new KieMemoryCompilerException(e.getMessage(), e);
            }
        }
        return toReturn;
    }
}

