/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.KieMemoryCompilerException;
import org.kie.memorycompiler.jdknative.NativeJavaCompiler;
import org.kie.memorycompiler.resources.MemoryResourceReader;
import org.kie.memorycompiler.resources.MemoryResourceStore;

public class KieMemoryCompiler {
    private KieMemoryCompiler() {
    }

    public static Map<String, Class<?>> compile(Map<String, String> classNameSourceMap, ClassLoader classLoader) {
        MemoryResourceReader reader = new MemoryResourceReader();
        MemoryResourceStore store = new MemoryResourceStore();
        String[] classNames = new String[classNameSourceMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : classNameSourceMap.entrySet()) {
            classNames[i] = KieMemoryCompiler.toJavaSource(entry.getKey());
            reader.add(classNames[i], entry.getValue().getBytes());
            ++i;
        }
        NativeJavaCompiler compiler = new NativeJavaCompiler();
        CompilationResult res = compiler.compile(classNames, reader, store, classLoader);
        if (res.getErrors().length > 0) {
            throw new KieMemoryCompilerException(Arrays.toString(res.getErrors()));
        }
        MemoryCompilerClassLoader kieMemoryCompilerClassLoader = new MemoryCompilerClassLoader(classLoader);
        HashMap toReturn = new HashMap();
        for (String className : classNameSourceMap.keySet()) {
            byte[] bytes = store.read(KieMemoryCompiler.toClassSource(className));
            kieMemoryCompilerClassLoader.addCode(className, bytes);
            try {
                toReturn.put(className, kieMemoryCompilerClassLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new KieMemoryCompilerException(e.getMessage(), e);
            }
        }
        return toReturn;
    }

    private static String toJavaSource(String s) {
        return s.replace('.', '/') + ".java";
    }

    private static String toClassSource(String s) {
        return s.replace('.', '/') + ".class";
    }

    public static class MemoryCompilerClassLoader
    extends ClassLoader {
        private Map<String, byte[]> customCompiledCode = new HashMap<String, byte[]>();

        public MemoryCompilerClassLoader(ClassLoader parent) {
            super(parent);
        }

        public void addCode(String name, byte[] bytes) {
            this.customCompiledCode.put(name, bytes);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] byteCode = this.customCompiledCode.get(name);
            if (byteCode == null) {
                return super.findClass(name);
            }
            return this.defineClass(name, byteCode, 0, byteCode.length);
        }
    }
}

