/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.executor.MavenRuntime;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.maven.plugin.KieMavenPluginBaseIntegrationTest;
import org.kie.maven.plugin.TestUtil;

public class KJarWithDMNIntegrationTest
extends KieMavenPluginBaseIntegrationTest {
    private static final String GROUP_ID = "org.kie";
    private static final String ARTIFACT_ID = "kie-maven-plugin-test-kjar-7";
    private static final String VERSION = "1.0.0.Final";
    private static final String KJAR_NAME = "kjar-7-with-dmn";

    public KJarWithDMNIntegrationTest(MavenRuntime.MavenRuntimeBuilder builder) {
        super(builder);
    }

    @Test
    public void testCleanInstall() throws Exception {
        this.buildKJarProject(KJAR_NAME, this.getMavenGoalsAndOptions(false));
    }

    @Test
    public void testComplexDMNModel() throws Exception {
        this.testComplexDMNModel(false);
    }

    @Test
    public void testComplexDMNModelWithExecutableModel() throws Exception {
        this.testComplexDMNModel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testComplexDMNModel(boolean useExecutableModel) throws Exception {
        if (useExecutableModel) {
            this.buildKJarProject(KJAR_NAME, this.getMavenGoalsAndOptions(true));
        } else {
            this.buildKJarProject(KJAR_NAME, this.getMavenGoalsAndOptions(false));
        }
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieSession kieSession = kieContainer.newKieSession();
        try {
            DMNRuntime dmnRuntime = (DMNRuntime)kieSession.getKieRuntime(DMNRuntime.class);
            DMNModel dmnModel = dmnRuntime.getModel("http://www.trisotech.com/definitions/_3068644b-d2c7-4b81-ab9d-64f011f81f47", "DMN Specification Chapter 11 Example");
            Assertions.assertThat((Object)dmnModel).isNotNull();
            Assertions.assertThat((List)dmnModel.getMessages()).isEmpty();
            DMNContext context = DMNFactory.newContext();
            context.set("Applicant data", this.getApplicantData());
            context.set("Bureau data", this.getBureauData());
            context.set("Requested product", this.getRequestedProduct());
            context.set("Supporting documents", null);
            DMNResult dmnResult = dmnRuntime.evaluateAll(dmnModel, context);
            Assertions.assertThat((List)dmnModel.getMessages()).isEmpty();
            DMNContext result = dmnResult.getContext();
            Assertions.assertThat((Object)result.get("Strategy")).isEqualTo((Object)"THROUGH");
            Assertions.assertThat((Object)result.get("Routing")).isEqualTo((Object)"ACCEPT");
        }
        finally {
            kieSession.dispose();
        }
    }

    private String[] getMavenGoalsAndOptions(boolean useExecutableModel) throws IOException {
        if (useExecutableModel) {
            return new String[]{"clean", "install", "-Ddrools.version=" + TestUtil.getProjectVersion(), "-DgenerateDMNModel=YES"};
        }
        return new String[]{"clean", "install", "-Ddrools.version=" + TestUtil.getProjectVersion()};
    }

    private Map<String, Object> getApplicantData() {
        HashMap<String, Object> applicantData = new HashMap<String, Object>();
        applicantData.put("Age", new BigDecimal(51));
        applicantData.put("MaritalStatus", "M");
        applicantData.put("EmploymentStatus", "EMPLOYED");
        applicantData.put("ExistingCustomer", false);
        HashMap<String, BigDecimal> monthlyMap = new HashMap<String, BigDecimal>();
        monthlyMap.put("Income", new BigDecimal(100000));
        monthlyMap.put("Repayments", new BigDecimal(2500));
        monthlyMap.put("Expenses", new BigDecimal(10000));
        applicantData.put("Monthly", monthlyMap);
        return applicantData;
    }

    private Map<String, Object> getBureauData() {
        HashMap<String, Object> bureauData = new HashMap<String, Object>();
        bureauData.put("Bankrupt", false);
        bureauData.put("CreditScore", new BigDecimal(600));
        return bureauData;
    }

    private Map<String, Object> getRequestedProduct() {
        HashMap<String, Object> requestedProduct = new HashMap<String, Object>();
        requestedProduct.put("ProductType", "STANDARD LOAN");
        requestedProduct.put("Rate", new BigDecimal(0.08));
        requestedProduct.put("Term", new BigDecimal(36));
        requestedProduct.put("Amount", new BigDecimal(100000));
        return requestedProduct;
    }
}

