/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.executor.MavenRuntime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.type.FactType;
import org.kie.maven.plugin.KieMavenPluginBaseIntegrationTest;
import org.kie.maven.plugin.TestUtil;

public class MultiModuleTest
extends KieMavenPluginBaseIntegrationTest {
    private static final String GROUP_ID = "org.kie";
    private static final String ARTIFACT_ID = "kie-maven-plugin-test-kjar-8-modA";
    private static final String VERSION = "1.0.0.Final";
    private static final String KJAR_NAME = "kjar-8-multimodule";

    public MultiModuleTest(MavenRuntime.MavenRuntimeBuilder builder) {
        super(builder);
    }

    @Test
    public void testMultiModuleWithExecutableModel() throws Exception {
        this.testMultiModuleExec(true);
    }

    @Test
    public void testMultiModule() throws Exception {
        this.testMultiModuleExec(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiModuleExec(boolean executableModel) throws Exception {
        String droolsVersionParameter = String.format("-Ddrools.version=%s", TestUtil.getProjectVersion());
        String executableModelParameter = String.format("-DgenerateModel=%s", executableModel ? "YES" : "NO");
        this.buildKJarProject(KJAR_NAME, "clean", "install", droolsVersionParameter, executableModelParameter);
        KieContainerImpl kContainer = null;
        KieServices kieServices = KieServices.Factory.get();
        ReleaseId releaseId = kieServices.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        try {
            kContainer = (KieContainerImpl)kieServices.newKieContainer(releaseId);
            Collection kieBaseNames = kContainer.getKieBaseNames();
            Assertions.assertThat((Iterable)kieBaseNames).hasSameElementsAs(Arrays.asList("modC", "modB", "modA"));
            List kiePackages = kieBaseNames.stream().map(arg_0 -> ((KieContainerImpl)kContainer).getKieBase(arg_0)).flatMap(kb -> kb.getKiePackages().stream()).collect(Collectors.toList());
            Assertions.assertThat(kiePackages.stream().map(KiePackage::getName).collect(Collectors.toList())).hasSameElementsAs(Arrays.asList("org.kie.modC", "org.kie.modB", "org.kie.modA"));
            List factTypes = kiePackages.stream().flatMap(kb -> kb.getFactTypes().stream()).collect(Collectors.toList());
            Assertions.assertThat(factTypes.stream().map(FactType::getName).collect(Collectors.toList())).hasSameElementsAs(Arrays.asList("org.kie.modC.FactC", "org.kie.modB.FactB", "org.kie.modA.FactA"));
        }
        finally {
            if (kContainer != null) {
                kContainer.dispose();
            }
        }
    }
}

