/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.executor.MavenRuntime;
import java.lang.reflect.Constructor;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.maven.plugin.KieMavenPluginBaseIntegrationTest;
import org.kie.maven.plugin.TestUtil;

public class DeclaredTypesTest
extends KieMavenPluginBaseIntegrationTest {
    private static final String GROUP_ID = "org.kie";
    private static final String ARTIFACT_ID = "kie-maven-plugin-test-kjar-9";
    private static final String VERSION = "1.0.0.Final";
    private static final String KJAR_NAME = "kjar-9-declared-types";

    public DeclaredTypesTest(MavenRuntime.MavenRuntimeBuilder builder) {
        super(builder);
    }

    @Test
    public void testDeclaredTypeWithJavaField() throws Exception {
        this.testDeclaredTypeWithJavaField(false);
    }

    @Test
    public void testDeclaredTypeWithJavaFieldExecutableModel() throws Exception {
        this.testDeclaredTypeWithJavaField(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeclaredTypeWithJavaField(boolean useExecutableModel) throws Exception {
        if (useExecutableModel) {
            this.buildKJarProject(KJAR_NAME, new String[]{"-Dorg.kie.version=" + TestUtil.getProjectVersion()}, "clean", "install");
        } else {
            this.buildKJarProject(KJAR_NAME, new String[]{"-Dorg.kie.version=" + TestUtil.getProjectVersion(), "-DgenerateModel=NO"}, "clean", "install");
        }
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieSession kSession = null;
        try {
            kSession = kieContainer.newKieSession("DeclaredTypeKBase.session");
            ClassLoader classLoader = kieContainer.getClassLoader();
            Class<?> aClass = Class.forName("org.declaredtype.FactA", true, classLoader);
            Constructor<?> constructor = aClass.getConstructor(String.class);
            Object lucaFactA = constructor.newInstance("Luca");
            kSession.insert(lucaFactA);
            int rulesFired = kSession.fireAllRules();
            kSession.dispose();
            Assert.assertEquals((long)1L, (long)rulesFired);
        }
        finally {
            kSession.dispose();
        }
    }
}

