/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.executor.MavenExecutionResult;
import io.takari.maven.testing.executor.MavenRuntime;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.maven.plugin.KieMavenPluginBaseIntegrationTest;
import org.kie.maven.plugin.TestUtil;

public class BuildPMMLTrustyTest
extends KieMavenPluginBaseIntegrationTest {
    private static final String PROJECT_NAME = "kjar-12-with-pmml-trusty";
    private static final String GAV_ARTIFACT_ID = "kie-maven-plugin-test-kjar-12";
    private static final String GAV_VERSION = "1.0.0.Final";
    private static final String PMML_FILE_NAME = "logisticregressionirisdata/logisticRegressionIrisData.pmml";
    private static final String EXAMPLE_PMML_CLASS = "compoundnestedpredicatescorecard/PMMLRuleMappersImpl.class";

    public BuildPMMLTrustyTest(MavenRuntime.MavenRuntimeBuilder builder) {
        super(builder);
    }

    @Test
    public void testContentKjarWithPMML() throws Exception {
        MavenExecutionResult result = this.buildKJarProject(PROJECT_NAME, new String[]{"-Dorg.kie.version=" + TestUtil.getProjectVersion()}, "clean", "install");
        File basedir = result.getBasedir();
        File kjarFile = new File(basedir, "target/kie-maven-plugin-test-kjar-12-1.0.0.Final.jar");
        Assertions.assertThat((File)kjarFile).exists();
        JarFile jarFile = new JarFile(kjarFile);
        HashSet<String> jarContent = new HashSet<String>();
        Enumeration<JarEntry> kjarEntries = jarFile.entries();
        while (kjarEntries.hasMoreElements()) {
            String entryName = kjarEntries.nextElement().getName();
            jarContent.add(entryName);
        }
        Assertions.assertThat(jarContent).isNotEmpty();
        Assertions.assertThat(jarContent).contains((Object[])new String[]{PMML_FILE_NAME});
        Assertions.assertThat(jarContent).contains((Object[])new String[]{EXAMPLE_PMML_CLASS});
    }
}

