/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.api.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasDataType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Value;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.MISSING_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.utils.PrimitiveBoxedUtils;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.commons.model.tuples.KiePMMLNameOpType;

public class ModelUtils {
    private ModelUtils() {
    }

    public static Optional<String> getTargetFieldName(List<Field<?>> fields, Model model) {
        return ModelUtils.getTargetFields(fields, model).stream().map(KiePMMLNameOpType::getName).findFirst();
    }

    public static DATA_TYPE getTargetFieldType(List<Field<?>> fields, Model model) {
        return ModelUtils.getTargetFieldsTypeMap(fields, model).entrySet().iterator().next().getValue();
    }

    public static List<KiePMMLNameOpType> getTargetFields(List<Field<?>> fields, Model model) {
        ArrayList<KiePMMLNameOpType> toReturn = new ArrayList<KiePMMLNameOpType>();
        if (model.getMiningSchema() != null && model.getMiningSchema().getMiningFields() != null) {
            for (org.dmg.pmml.MiningField miningField : model.getMiningSchema().getMiningFields()) {
                if (!MiningField.UsageType.TARGET.equals((Object)miningField.getUsageType()) && !MiningField.UsageType.PREDICTED.equals((Object)miningField.getUsageType())) continue;
                OP_TYPE opType = ModelUtils.getOpType(fields, model, miningField.getName().getValue());
                toReturn.add(new KiePMMLNameOpType(miningField.getName().getValue(), opType));
            }
        }
        return toReturn;
    }

    public static Map<String, DATA_TYPE> getTargetFieldsTypeMap(List<Field<?>> fields, Model model) {
        LinkedHashMap<String, DATA_TYPE> toReturn = new LinkedHashMap<String, DATA_TYPE>();
        if (model.getMiningSchema() != null && model.getMiningSchema().getMiningFields() != null) {
            for (org.dmg.pmml.MiningField miningField : model.getMiningSchema().getMiningFields()) {
                if (!MiningField.UsageType.TARGET.equals((Object)miningField.getUsageType()) && !MiningField.UsageType.PREDICTED.equals((Object)miningField.getUsageType())) continue;
                toReturn.put(miningField.getName().getValue(), ModelUtils.getDATA_TYPE(fields, miningField.getName().getValue()));
            }
        }
        return toReturn;
    }

    public static OP_TYPE getOpType(List<Field<?>> fields, Model model, String targetFieldName) {
        return Stream.of(ModelUtils.getOpTypeFromTargets(model.getTargets(), targetFieldName), ModelUtils.getOpTypeFromMiningFields(model.getMiningSchema(), targetFieldName), ModelUtils.getOpTypeFromFields(fields, targetFieldName)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find OpType for field %s", targetFieldName)));
    }

    public static Optional<OP_TYPE> getOpTypeFromFields(List<Field<?>> fields, String fieldName) {
        return fields == null ? Optional.empty() : fields.stream().filter(dataField -> Objects.equals(fieldName, dataField.getName().getValue()) && dataField.getOpType() != null).map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value())).findFirst();
    }

    public static Optional<OP_TYPE> getOpTypeFromMiningFields(MiningSchema miningSchema, String fieldName) {
        if (miningSchema != null && miningSchema.getMiningFields() != null) {
            return miningSchema.getMiningFields().stream().filter(miningField -> Objects.equals(fieldName, miningField.getName().getValue()) && miningField.getOpType() != null).findFirst().map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value()));
        }
        return Optional.empty();
    }

    public static Optional<OP_TYPE> getOpTypeFromTargets(Targets targets, String fieldName) {
        if (targets != null && targets.getTargets() != null) {
            return targets.getTargets().stream().filter(target -> Objects.equals(fieldName, target.getField().getValue()) && target.getOpType() != null).findFirst().map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value()));
        }
        return Optional.empty();
    }

    public static DataType getDataType(List<Field<?>> fields, String fieldName) {
        return fields.stream().filter(fld -> Objects.equals(fieldName, fld.getName().getValue())).map(HasDataType::getDataType).findFirst().orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find DataType for field %s", fieldName)));
    }

    public static DATA_TYPE getDATA_TYPE(List<Field<?>> fields, String targetFieldName) {
        Optional<DATA_TYPE> toReturn = fields.stream().filter(fld -> Objects.equals(targetFieldName, fld.getName().getValue())).findFirst().map(dataField -> DATA_TYPE.byName((String)dataField.getDataType().value()));
        return toReturn.orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find DataType for field %s", targetFieldName)));
    }

    public static List<DerivedField> getDerivedFields(TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        ArrayList<DerivedField> toReturn = new ArrayList<DerivedField>();
        if (transformationDictionary != null && transformationDictionary.getDerivedFields() != null) {
            toReturn.addAll(transformationDictionary.getDerivedFields());
        }
        if (localTransformations != null && localTransformations.getDerivedFields() != null) {
            toReturn.addAll(localTransformations.getDerivedFields());
        }
        return toReturn;
    }

    public static List<Object> getObjectsFromArray(Array source) {
        String[] valuesArray;
        Array.Type type = source.getType();
        ArrayList<Object> toReturn = new ArrayList<Object>();
        String stringValue = (String)source.getValue();
        block5: for (String s : valuesArray = stringValue.split(" ")) {
            switch (type) {
                case INT: {
                    toReturn.add(Integer.valueOf(s));
                    continue block5;
                }
                case STRING: {
                    toReturn.add(s);
                    continue block5;
                }
                case REAL: {
                    toReturn.add(Double.valueOf(s));
                    continue block5;
                }
                default: {
                    throw new KiePMMLException("Unknown Array " + type);
                }
            }
        }
        return toReturn;
    }

    public static List<MiningField> convertToKieMiningFieldList(MiningSchema toConvert, List<Field<?>> fields) {
        if (toConvert == null || !toConvert.hasMiningFields()) {
            return Collections.emptyList();
        }
        return toConvert.getMiningFields().stream().map(miningField -> {
            Field field = fields.stream().filter(fld -> fld.getName().equals((Object)miningField.getName())).findFirst().orElseThrow(() -> new KiePMMLException("Cannot find " + miningField.getName() + " in DataDictionary"));
            return ModelUtils.convertToKieMiningField(miningField, field);
        }).collect(Collectors.toList());
    }

    public static MiningField convertToKieMiningField(org.dmg.pmml.MiningField toConvert, Field<?> field) {
        String name = toConvert.getName() != null ? toConvert.getName().getValue() : null;
        FIELD_USAGE_TYPE fieldUsageType = toConvert.getUsageType() != null ? FIELD_USAGE_TYPE.byName((String)toConvert.getUsageType().value()) : null;
        OP_TYPE opType = toConvert.getOpType() != null ? OP_TYPE.byName((String)toConvert.getOpType().value()) : null;
        DATA_TYPE dataType = field.getDataType() != null ? DATA_TYPE.byName((String)field.getDataType().value()) : null;
        MISSING_VALUE_TREATMENT_METHOD missingValueTreatmentMethod = toConvert.getMissingValueTreatment() != null ? MISSING_VALUE_TREATMENT_METHOD.byName((String)toConvert.getMissingValueTreatment().value()) : null;
        INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod = toConvert.getInvalidValueTreatment() != null ? INVALID_VALUE_TREATMENT_METHOD.byName((String)toConvert.getInvalidValueTreatment().value()) : null;
        String missingValueReplacement = toConvert.getMissingValueReplacement() != null ? toConvert.getMissingValueReplacement().toString() : null;
        String invalidValueReplacement = toConvert.getInvalidValueReplacement() != null ? toConvert.getInvalidValueReplacement().toString() : null;
        List allowedValues = field instanceof DataField ? ModelUtils.convertDataFieldValues(((DataField)field).getValues()) : Collections.emptyList();
        List intervals = field instanceof DataField ? ModelUtils.convertDataFieldIntervals(((DataField)field).getIntervals()) : Collections.emptyList();
        return new MiningField(name, fieldUsageType, opType, dataType, missingValueTreatmentMethod, invalidValueTreatmentMethod, missingValueReplacement, invalidValueReplacement, allowedValues, intervals);
    }

    public static List<OutputField> convertToKieOutputFieldList(Output toConvert, List<Field<?>> fields) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.getOutputFields().stream().map(outputField -> {
            Field field = fields.stream().filter(fld -> fld.getName().equals((Object)outputField.getTargetField())).findFirst().orElse(null);
            return ModelUtils.convertToKieOutputField(outputField, field);
        }).collect(Collectors.toList());
    }

    public static OutputField convertToKieOutputField(org.dmg.pmml.OutputField toConvert, Field<?> field) {
        String name = toConvert.getName() != null ? toConvert.getName().getValue() : null;
        OP_TYPE opType = toConvert.getOpType() != null ? OP_TYPE.byName((String)toConvert.getOpType().value()) : null;
        DATA_TYPE dataFieldDataType = field != null ? DATA_TYPE.byName((String)field.getDataType().value()) : null;
        DATA_TYPE dataType = toConvert.getDataType() != null ? DATA_TYPE.byName((String)toConvert.getDataType().value()) : dataFieldDataType;
        String targetField = toConvert.getTargetField() != null ? toConvert.getTargetField().getValue() : null;
        RESULT_FEATURE resultFeature = toConvert.getResultFeature() != null ? RESULT_FEATURE.byName((String)toConvert.getResultFeature().value()) : null;
        List<String> allowedValues = field instanceof DataField ? ModelUtils.convertDataFieldValues(((DataField)field).getValues()) : null;
        return new OutputField(name, opType, dataType, targetField, resultFeature, allowedValues);
    }

    public static List<KiePMMLTarget> convertToKiePMMLTargetList(Targets toConvert) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.getTargets().stream().map(ModelUtils::convertToKiePMMLTarget).collect(Collectors.toList());
    }

    public static KiePMMLTarget convertToKiePMMLTarget(Target toConvert) {
        Double rescaleFactor;
        Double rescaleConstant;
        Double max;
        Double min;
        CAST_INTEGER castInteger;
        String field;
        OP_TYPE opType;
        KiePMMLTarget.Builder builder = KiePMMLTarget.builder((String)("" + toConvert.hashCode()), Collections.emptyList());
        List<KiePMMLTargetValue> targetValues = ModelUtils.convertToKiePMMLTargetValueList(toConvert.getTargetValues());
        if (!targetValues.isEmpty()) {
            builder.withTargetValues(targetValues);
        }
        OP_TYPE oP_TYPE = opType = toConvert.getOpType() != null ? OP_TYPE.byName((String)toConvert.getOpType().value()) : null;
        if (opType != null) {
            builder.withOpType(opType);
        }
        String string = field = toConvert.getField() != null ? toConvert.getField().getValue() : null;
        if (field != null) {
            builder.withField(field);
        }
        CAST_INTEGER cAST_INTEGER = castInteger = toConvert.getCastInteger() != null ? CAST_INTEGER.byName((String)toConvert.getCastInteger().value()) : null;
        if (castInteger != null) {
            builder.withCastInteger(castInteger);
        }
        Double d = min = toConvert.getMin() != null ? Double.valueOf(toConvert.getMin().doubleValue()) : null;
        if (min != null) {
            builder.withMin(min.doubleValue());
        }
        Double d2 = max = toConvert.getMax() != null ? Double.valueOf(toConvert.getMax().doubleValue()) : null;
        if (max != null) {
            builder.withMax(max.doubleValue());
        }
        Double d3 = rescaleConstant = toConvert.getRescaleConstant() != null ? Double.valueOf(toConvert.getRescaleConstant().doubleValue()) : null;
        if (rescaleConstant != null) {
            builder.withRescaleConstant(rescaleConstant.doubleValue());
        }
        Double d4 = rescaleFactor = toConvert.getRescaleFactor() != null ? Double.valueOf(toConvert.getRescaleFactor().doubleValue()) : null;
        if (rescaleFactor != null) {
            builder.withRescaleFactor(rescaleFactor.doubleValue());
        }
        return (KiePMMLTarget)builder.build();
    }

    public static List<KiePMMLTargetValue> convertToKiePMMLTargetValueList(List<TargetValue> toConvert) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.stream().map(ModelUtils::convertToKiePMMLTargetValue).collect(Collectors.toList());
    }

    public static KiePMMLTargetValue convertToKiePMMLTargetValue(TargetValue toConvert) {
        String value = toConvert.getValue() != null ? toConvert.getValue().toString() : null;
        String displayValue = toConvert.getDisplayValue() != null ? toConvert.getDisplayValue() : null;
        KiePMMLTargetValue.Builder builder = KiePMMLTargetValue.builder((String)("" + toConvert.hashCode()), Collections.emptyList()).withValue(value).withDisplayValue(displayValue).withPriorProbability(toConvert.getPriorProbability()).withDefaultValue(toConvert.getDefaultValue());
        return (KiePMMLTargetValue)builder.build();
    }

    public static String getBoxedClassName(ParameterField parameterField) {
        return parameterField.getDataType() == null ? Object.class.getName() : ModelUtils.getBoxedClassName(parameterField.getDataType());
    }

    public static String getBoxedClassName(DataType dataType) {
        Class c = dataType == null ? Object.class : DATA_TYPE.byName((String)dataType.value()).getMappedClass();
        return PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed((Class)c).map(primitiveBoxed -> primitiveBoxed.getBoxed().getName()).orElse(c.getName());
    }

    public static List<Field<?>> getFieldsFromDataDictionaryAndTransformationDictionary(DataDictionary dataDictionary, TransformationDictionary transformationDictionary) {
        ArrayList toReturn = new ArrayList();
        if (dataDictionary != null && dataDictionary.hasDataFields()) {
            dataDictionary.getDataFields().stream().map(Field.class::cast).forEach(toReturn::add);
        }
        if (transformationDictionary != null && transformationDictionary.hasDerivedFields()) {
            transformationDictionary.getDerivedFields().stream().map(Field.class::cast).forEach(toReturn::add);
        }
        return toReturn;
    }

    public static List<Field<?>> getFieldsFromDataDictionaryTransformationDictionaryAndModel(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Model model) {
        Output output;
        List<Field<?>> toReturn = ModelUtils.getFieldsFromDataDictionaryAndTransformationDictionary(dataDictionary, transformationDictionary);
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            localTransformations.getDerivedFields().stream().map(Field.class::cast).forEach(toReturn::add);
        }
        if ((output = model.getOutput()) != null && output.hasOutputFields()) {
            output.getOutputFields().stream().map(Field.class::cast).forEach(toReturn::add);
        }
        return toReturn;
    }

    static List<String> convertDataFieldValues(List<Value> toConvert) {
        return toConvert != null ? toConvert.stream().map(value -> value.getValue().toString()).collect(Collectors.toList()) : null;
    }

    static List<Interval> convertDataFieldIntervals(List<org.dmg.pmml.Interval> toConvert) {
        return toConvert != null ? toConvert.stream().map(interval -> new Interval(interval.getLeftMargin(), interval.getRightMargin())).collect(Collectors.toList()) : null;
    }
}

