/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.io.InputStream;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.drools.util.FileUtils;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.mocks.PMMLCompilationContextMock;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;

public class KiePMMLModelRetrieverTest {
    private static final String MULTIPLE_TARGETS_SOURCE = "MultipleTargetsFieldSample.pmml";
    private static final String ONE_MINING_TARGET_SOURCE = "OneMiningTargetFieldSample.pmml";
    private static final String MINING_MODEL_WITH_NESTED_REFERS_SOURCE = "MiningWithNestedRefers.pmml";
    private PMML pmml;

    @Test
    void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesWithProvider() {
        this.pmml = PMMLModelTestUtils.getPMMLWithRandomTestModel();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)((Model)this.pmml.getModels().get(0)), (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)"fileName");
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((CompilationDTO)compilationDTO);
        Assertions.assertThat((Optional)retrieved).isNotNull();
    }

    @Disabled(value="Temporarily disabled: See https://github.com/apache/incubator-kie-drools/issues/6165")
    @Test
    void getFromDataDictionaryAndModelWithSourcesWithoutProvider() throws Exception {
        String fileName = ONE_MINING_TARGET_SOURCE.substring(0, ONE_MINING_TARGET_SOURCE.lastIndexOf(46));
        this.pmml = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)((Model)this.pmml.getModels().get(0)), (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)fileName);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((CompilationDTO)compilationDTO);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((Optional)retrieved).isNotPresent();
    }

    @Test
    void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiledWithProvider() throws Exception {
        this.pmml = PMMLModelTestUtils.getPMMLWithMiningRandomTestModel();
        MiningModel parentModel = (MiningModel)this.pmml.getModels().get(0);
        Model model = ((Segment)parentModel.getSegmentation().getSegments().get(0)).getModel();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)model, (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)"fileName");
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled((CompilationDTO)compilationDTO);
        ((OptionalAssert)Assertions.assertThat((Optional)retrieved).isNotNull()).isPresent();
    }

    @Test
    void getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiledWithoutProvider() throws Exception {
        String fileName = MINING_MODEL_WITH_NESTED_REFERS_SOURCE.substring(0, MINING_MODEL_WITH_NESTED_REFERS_SOURCE.lastIndexOf(46));
        this.pmml = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MINING_MODEL_WITH_NESTED_REFERS_SOURCE), (String)MINING_MODEL_WITH_NESTED_REFERS_SOURCE);
        MiningModel parentModel = (MiningModel)this.pmml.getModels().get(0);
        Model model = ((Segment)parentModel.getSegmentation().getSegments().get(0)).getModel();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)this.pmml, (Model)model, (PMMLCompilationContext)new PMMLCompilationContextMock(), (String)fileName);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled((CompilationDTO)compilationDTO);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((Optional)retrieved).isNotPresent();
    }
}

