/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ListAssert;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;

public class CommonCodegenUtilsTest {
    @Test
    void populateMethodDeclarations() {
        List toAdd = IntStream.range(0, 5).boxed().map(index -> this.getMethodDeclaration("METHOD_" + index)).collect(Collectors.toList());
        ClassOrInterfaceDeclaration toPopulate = new ClassOrInterfaceDeclaration();
        Assertions.assertThat((List)toPopulate.getMembers()).isEmpty();
        CommonCodegenUtils.populateMethodDeclarations((ClassOrInterfaceDeclaration)toPopulate, toAdd);
        NodeList retrieved = toPopulate.getMembers();
        Assertions.assertThat((List)retrieved).hasSameSizeAs(toAdd);
        Assertions.assertThat((boolean)toAdd.stream().anyMatch(methodDeclaration -> retrieved.stream().anyMatch(bodyDeclaration -> bodyDeclaration.equals(methodDeclaration)))).isTrue();
    }

    @Test
    void getFilteredKiePMMLNameValueExpression() {
        String kiePMMLNameValueListParam = "KIEPMMLNAMEVALUELISTPARAM";
        String fieldNameToRef = "FIELDNAMETOREF";
        ExpressionStmt retrieved = CommonCodegenUtils.getFilteredKiePMMLNameValueExpression((String)kiePMMLNameValueListParam, (String)fieldNameToRef, (boolean)true);
        Assertions.assertThat((Object)retrieved).isNotNull();
        String expected = String.format("%1$s<%2$s> %3$s = %4$s.stream().filter((%2$s %5$s) -> %6$s.equals(\"%7$s\", %5$s.getName())).findFirst();", Optional.class.getName(), KiePMMLNameValue.class.getName(), CommonCodegenUtils.OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME, kiePMMLNameValueListParam, "lmbdParam", Objects.class.getName(), fieldNameToRef);
        String retrievedString = retrieved.toString();
        Assertions.assertThat((String)retrievedString).isEqualTo(expected);
        BlockStmt body = new BlockStmt();
        body.addStatement((Statement)retrieved);
        Parameter listParameter = new Parameter((Type)CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName())), kiePMMLNameValueListParam);
        Parameter fieldRefParameter = new Parameter((Type)StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName()), fieldNameToRef);
        CodegenTestUtils.commonValidateCompilation(body, Arrays.asList(listParameter, fieldRefParameter));
        retrieved = CommonCodegenUtils.getFilteredKiePMMLNameValueExpression((String)kiePMMLNameValueListParam, (String)fieldNameToRef, (boolean)false);
        Assertions.assertThat((Object)retrieved).isNotNull();
        expected = String.format("%1$s<%2$s> %3$s = %4$s.stream().filter((%2$s %5$s) -> %6$s.equals(%7$s, %5$s.getName())).findFirst();", Optional.class.getName(), KiePMMLNameValue.class.getName(), CommonCodegenUtils.OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME, kiePMMLNameValueListParam, "lmbdParam", Objects.class.getName(), fieldNameToRef);
        retrievedString = retrieved.toString();
        Assertions.assertThat((String)retrievedString).isEqualTo(expected);
        body = new BlockStmt();
        body.addStatement((Statement)retrieved);
        listParameter = new Parameter((Type)CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName())), kiePMMLNameValueListParam);
        fieldRefParameter = new Parameter((Type)StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName()), fieldNameToRef);
        CodegenTestUtils.commonValidateCompilation(body, Arrays.asList(listParameter, fieldRefParameter));
    }

    @Test
    void addMapPopulation() {
        Map<String, MethodDeclaration> toAdd = IntStream.range(0, 5).boxed().collect(Collectors.toMap(index -> "KEY_" + index, index -> this.getMethodDeclaration("METHOD_" + index)));
        BlockStmt body = new BlockStmt();
        String mapName = "MAP_NAME";
        CommonCodegenUtils.addMapPopulation(toAdd, (BlockStmt)body, (String)mapName);
        NodeList statements = body.getStatements();
        Assertions.assertThat((List)statements).hasSize(toAdd.size());
        for (Statement statement2 : statements) {
            Assertions.assertThat((Object)statement2).isInstanceOf(ExpressionStmt.class);
            ExpressionStmt expressionStmt = (ExpressionStmt)statement2;
            Expression expression = expressionStmt.getExpression();
            Assertions.assertThat((Object)expression).isInstanceOf(MethodCallExpr.class);
            MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
            NodeList arguments = methodCallExpr.getArguments();
            Assertions.assertThat((List)arguments).hasSize(2);
            Assertions.assertThat((Object)((Expression)arguments.get(0))).isInstanceOf(StringLiteralExpr.class);
            Assertions.assertThat((Object)((Expression)arguments.get(1))).isInstanceOf(MethodReferenceExpr.class);
            MethodReferenceExpr methodReferenceExpr = (MethodReferenceExpr)arguments.get(1);
            Assertions.assertThat((Object)methodReferenceExpr.getScope()).isInstanceOf(ThisExpr.class);
            Expression scope = methodCallExpr.getScope().orElse(null);
            Assertions.assertThat((Object)scope).isNotNull();
            Assertions.assertThat((Object)scope).isInstanceOf(NameExpr.class);
            Assertions.assertThat((String)((NameExpr)scope).getNameAsString()).isEqualTo(mapName);
        }
        for (Map.Entry<String, MethodDeclaration> entry : toAdd.entrySet()) {
            int matchingDeclarations = (int)statements.stream().filter(statement -> {
                ExpressionStmt expressionStmt = (ExpressionStmt)statement;
                Expression expression = expressionStmt.getExpression();
                MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
                NodeList arguments = methodCallExpr.getArguments();
                if (!((String)entry.getKey()).equals(((StringLiteralExpr)arguments.get(0)).getValue())) {
                    return false;
                }
                MethodReferenceExpr methodReferenceExpr = (MethodReferenceExpr)arguments.get(1);
                return ((MethodDeclaration)entry.getValue()).getName().asString().equals(methodReferenceExpr.getIdentifier());
            }).count();
            Assertions.assertThat((int)matchingDeclarations).isEqualTo(1);
        }
    }

    @Test
    void addMapPopulationExpression() {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("one", new StringLiteralExpr("ONE"));
        inputMap.put("two", new IntegerLiteralExpr("2"));
        inputMap.put("three", new DoubleLiteralExpr("3.0"));
        BlockStmt inputBody = new BlockStmt();
        String inputMapName = "testMap";
        CommonCodegenUtils.addMapPopulationExpressions(inputMap, (BlockStmt)inputBody, (String)inputMapName);
        NodeList statements = inputBody.getStatements();
        Assertions.assertThat((List)statements).hasSize(inputMap.size());
        ArrayList<MethodCallExpr> methodCallExprs = new ArrayList<MethodCallExpr>(statements.size());
        for (Statement statement : statements) {
            Assertions.assertThat((Object)statement).isInstanceOf(ExpressionStmt.class);
            Expression expression = ((ExpressionStmt)statement).getExpression();
            Assertions.assertThat((Object)expression).isInstanceOf(MethodCallExpr.class);
            MethodCallExpr methodCallExpr2 = (MethodCallExpr)expression;
            Assertions.assertThat((String)methodCallExpr2.getScope().map(Node::toString).orElse(null)).isEqualTo(inputMapName);
            Assertions.assertThat((String)methodCallExpr2.getName().asString()).isEqualTo("put");
            Assertions.assertThat((List)methodCallExpr2.getArguments()).hasSize(2);
            Assertions.assertThat((Object)methodCallExpr2.getArgument(0)).isInstanceOf(StringLiteralExpr.class);
            methodCallExprs.add(methodCallExpr2);
        }
        for (Map.Entry inputEntry : inputMap.entrySet()) {
            ((ListAssert)Assertions.assertThat(methodCallExprs.stream().filter(methodCallExpr -> {
                StringLiteralExpr arg0 = (StringLiteralExpr)methodCallExpr.getArgument(0);
                return arg0.asString().equals(inputEntry.getKey()) && methodCallExpr.getArgument(1).equals(inputEntry.getValue());
            })).as("Expected one and only one statement for key \"" + (String)inputEntry.getKey() + "\"", new Object[0])).hasSize(1);
        }
    }

    @Test
    void addListPopulation() {
        List toAdd = IntStream.range(0, 5).mapToObj(i -> {
            ObjectCreationExpr toReturn = new ObjectCreationExpr();
            toReturn.setType(String.class);
            StringLiteralExpr value = new StringLiteralExpr("String" + i);
            toReturn.setArguments(NodeList.nodeList((Node[])new Expression[]{value}));
            return toReturn;
        }).collect(Collectors.toList());
        BlockStmt body = new BlockStmt();
        String listName = "LIST_NAME";
        CommonCodegenUtils.addListPopulationByObjectCreationExpr(toAdd, (BlockStmt)body, (String)listName);
        NodeList statements = body.getStatements();
        Assertions.assertThat((List)statements).hasSameSizeAs(toAdd);
        for (Statement statement2 : statements) {
            Assertions.assertThat((Object)statement2).isInstanceOf(ExpressionStmt.class);
            ExpressionStmt expressionStmt = (ExpressionStmt)statement2;
            Assertions.assertThat((Object)expressionStmt.getExpression()).isInstanceOf(MethodCallExpr.class);
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionStmt.getExpression();
            Assertions.assertThat((String)((Expression)methodCallExpr.getScope().get()).asNameExpr().getNameAsString()).isEqualTo(listName);
            NodeList arguments = methodCallExpr.getArguments();
            Assertions.assertThat((List)arguments).hasSize(1);
            Assertions.assertThat((Object)((Expression)arguments.get(0))).isInstanceOf(ObjectCreationExpr.class);
            ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)arguments.get(0);
            Assertions.assertThat((String)String.class.getSimpleName()).isEqualTo(objectCreationExpr.getType().asString());
            arguments = objectCreationExpr.getArguments();
            Assertions.assertThat((List)arguments).hasSize(1);
            Assertions.assertThat((Object)((Expression)arguments.get(0))).isInstanceOf(StringLiteralExpr.class);
        }
        for (ObjectCreationExpr entry : toAdd) {
            int matchingDeclarations = (int)statements.stream().filter(statement -> {
                ExpressionStmt expressionStmt = (ExpressionStmt)statement;
                Expression expression = expressionStmt.getExpression();
                MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
                NodeList arguments = methodCallExpr.getArguments();
                return entry.equals((Object)((Expression)arguments.get(0)).asObjectCreationExpr());
            }).count();
            Assertions.assertThat((int)matchingDeclarations).isEqualTo(1);
        }
    }

    @Test
    void createArraysAsListExpression() {
        ExpressionStmt retrieved = CommonCodegenUtils.createArraysAsListExpression();
        Assertions.assertThat((Object)retrieved).isNotNull();
        String expected = "java.util.Arrays.asList();";
        String retrievedString = retrieved.toString();
        Assertions.assertThat((String)retrievedString).isEqualTo(expected);
    }

    @Test
    void createArraysAsListFromList() {
        List strings = IntStream.range(0, 3).mapToObj(i -> "Element" + i).collect(Collectors.toList());
        ExpressionStmt retrieved = CommonCodegenUtils.createArraysAsListFromList(strings);
        Assertions.assertThat((Object)retrieved).isNotNull();
        String arguments = strings.stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(", "));
        String expected = String.format("java.util.Arrays.asList(%s);", arguments);
        String retrievedString = retrieved.toString();
        Assertions.assertThat((String)retrievedString).isEqualTo(expected);
        List doubles = IntStream.range(0, 3).mapToObj(i -> (double)i * 0.17).collect(Collectors.toList());
        retrieved = CommonCodegenUtils.createArraysAsListFromList(doubles);
        Assertions.assertThat((Object)retrieved).isNotNull();
        arguments = doubles.stream().map(String::valueOf).collect(Collectors.joining(", "));
        expected = String.format("java.util.Arrays.asList(%s);", arguments);
        retrievedString = retrieved.toString();
        Assertions.assertThat((String)retrievedString).isEqualTo(expected);
    }

    @Test
    void getParamMethodDeclaration() {
        String methodName = "METHOD_NAME";
        HashMap<String, ClassOrInterfaceType> parameterNameTypeMap = new HashMap<String, ClassOrInterfaceType>();
        parameterNameTypeMap.put("stringParam", StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName()));
        parameterNameTypeMap.put("kiePMMLNameValueParam", StaticJavaParser.parseClassOrInterfaceType((String)KiePMMLNameValue.class.getName()));
        parameterNameTypeMap.put("listParam", new ClassOrInterfaceType(null, new SimpleName(List.class.getName()), NodeList.nodeList((Node[])new Type[]{StaticJavaParser.parseClassOrInterfaceType((String)KiePMMLNameValue.class.getName())})));
        MethodDeclaration retrieved = CommonCodegenUtils.getMethodDeclaration((String)methodName, parameterNameTypeMap);
        this.commonValidateMethodDeclaration(retrieved, methodName);
        this.commonValidateMethodDeclarationParams(retrieved, parameterNameTypeMap);
    }

    @Test
    void getNoParamMethodDeclarationByString() {
        String methodName = "METHOD_NAME";
        MethodDeclaration retrieved = CommonCodegenUtils.getMethodDeclaration((String)methodName);
        this.commonValidateMethodDeclaration(retrieved, methodName);
    }

    @Test
    void getReturnStmt() {
        String returnedVariable = "RETURNED_VARIABLE";
        ReturnStmt retrieved = CommonCodegenUtils.getReturnStmt((String)returnedVariable);
        String expected = String.format("return %s;", returnedVariable);
        Assertions.assertThat((String)retrieved.toString()).isEqualTo(expected);
    }

    @Test
    void getTypedClassOrInterfaceType() {
        String className = "CLASS_NAME";
        List<String> typesName = Arrays.asList("TypeA", "TypeB");
        ClassOrInterfaceType retrieved = CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)className, typesName);
        Assertions.assertThat((Object)retrieved).isNotNull();
        String expected = String.format("%1$s<%2$s,%3$s>", className, typesName.get(0), typesName.get(1));
        Assertions.assertThat((String)retrieved.asString()).isEqualTo(expected);
    }

    @Test
    void setAssignExpressionValueMatch() {
        BlockStmt body = new BlockStmt();
        AssignExpr assignExpr = new AssignExpr();
        assignExpr.setTarget((Expression)new NameExpr("MATCH"));
        body.addStatement((Expression)assignExpr);
        DoubleLiteralExpr value = new DoubleLiteralExpr(24.22);
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"MATCH", (Expression)value);
        Assertions.assertThat((Object)assignExpr.getValue()).isEqualTo((Object)value);
    }

    @Test
    void setAssignExpressionValueNoMatch() {
        AssertionsForClassTypes.assertThatExceptionOfType(KiePMMLException.class).isThrownBy(() -> {
            BlockStmt body = new BlockStmt();
            AssignExpr assignExpr = new AssignExpr();
            assignExpr.setTarget((Expression)new NameExpr("MATCH"));
            body.addStatement((Expression)assignExpr);
            CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"NOMATCH", (Expression)new DoubleLiteralExpr(24.22));
        });
    }

    @Test
    void setAssignExpressionValueNoAssignExpressions() {
        AssertionsForClassTypes.assertThatExceptionOfType(KiePMMLException.class).isThrownBy(() -> {
            BlockStmt body = new BlockStmt();
            CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"NOMATCH", (Expression)new DoubleLiteralExpr(24.22));
        });
    }

    @Test
    void getAssignExpression() {
        BlockStmt body = new BlockStmt();
        Optional retrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"NOMATCH");
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        AssignExpr assignExpr = new AssignExpr();
        assignExpr.setTarget((Expression)new NameExpr("MATCH"));
        body.addStatement((Expression)assignExpr);
        retrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"NOMATCH");
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"MATCH");
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((Optional)retrieved).isPresent();
        AssignExpr retrievedAssignExpr = (AssignExpr)retrieved.get();
        Assertions.assertThat((Object)retrievedAssignExpr).isEqualTo((Object)assignExpr);
    }

    @Test
    void getExplicitConstructorInvocationStmt() {
        BlockStmt body = new BlockStmt();
        Optional retrieved = CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt = new ExplicitConstructorInvocationStmt();
        body.addStatement((Statement)explicitConstructorInvocationStmt);
        retrieved = CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body);
        Assertions.assertThat((Optional)retrieved).isNotNull();
        Assertions.assertThat((Optional)retrieved).isPresent();
        ExplicitConstructorInvocationStmt retrievedExplicitConstructorInvocationStmt = (ExplicitConstructorInvocationStmt)retrieved.get();
        Assertions.assertThat((Object)retrievedExplicitConstructorInvocationStmt).isEqualTo((Object)explicitConstructorInvocationStmt);
    }

    @Test
    void setExplicitConstructorInvocationStmtArgumentWithParameter() {
        String parameterName = "PARAMETER_NAME";
        String value = "VALUE";
        ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt = new ExplicitConstructorInvocationStmt();
        explicitConstructorInvocationStmt.setArguments(NodeList.nodeList((Node[])new Expression[]{new NameExpr("NOT_PARAMETER"), new NameExpr("PARAMETER_NAME")}));
        Assertions.assertThat((Optional)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME")).isPresent();
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME", (String)"VALUE");
        Assertions.assertThat((Optional)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME")).isNotPresent();
        Assertions.assertThat((Optional)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"VALUE")).isPresent();
    }

    @Test
    void setExplicitConstructorInvocationStmtArgumentNoParameter() {
        AssertionsForClassTypes.assertThatExceptionOfType(KiePMMLException.class).isThrownBy(() -> {
            String parameterName = "PARAMETER_NAME";
            ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt = new ExplicitConstructorInvocationStmt();
            explicitConstructorInvocationStmt.setArguments(NodeList.nodeList((Node[])new Expression[]{new NameExpr("NOT_PARAMETER")}));
            CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME", (String)"VALUE");
        });
    }

    @Test
    void getExplicitConstructorInvocationParameter() {
        String parameterName = "PARAMETER_NAME";
        ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt = new ExplicitConstructorInvocationStmt();
        Assertions.assertThat((Optional)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME")).isNotPresent();
        explicitConstructorInvocationStmt.setArguments(NodeList.nodeList((Node[])new Expression[]{new NameExpr("NOT_PARAMETER")}));
        Assertions.assertThat((Optional)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME")).isNotPresent();
        explicitConstructorInvocationStmt.setArguments(NodeList.nodeList((Node[])new Expression[]{new NameExpr("NOT_PARAMETER"), new NameExpr("PARAMETER_NAME")}));
        Assertions.assertThat((Optional)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME")).isPresent();
    }

    @Test
    void getMethodDeclaration() {
        String methodName = "METHOD_NAME";
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration();
        Assertions.assertThat((Optional)CommonCodegenUtils.getMethodDeclaration((ClassOrInterfaceDeclaration)classOrInterfaceDeclaration, (String)"METHOD_NAME")).isNotPresent();
        classOrInterfaceDeclaration.addMethod("NOT_METHOD", new Modifier.Keyword[0]);
        Assertions.assertThat((Optional)CommonCodegenUtils.getMethodDeclaration((ClassOrInterfaceDeclaration)classOrInterfaceDeclaration, (String)"METHOD_NAME")).isNotPresent();
        classOrInterfaceDeclaration.addMethod("METHOD_NAME", new Modifier.Keyword[0]);
        Assertions.assertThat((Optional)CommonCodegenUtils.getMethodDeclaration((ClassOrInterfaceDeclaration)classOrInterfaceDeclaration, (String)"METHOD_NAME")).isPresent();
    }

    @Test
    void addMethod() {
        MethodDeclaration methodTemplate = new MethodDeclaration();
        methodTemplate.setName("methodTemplate");
        BlockStmt body = new BlockStmt();
        methodTemplate.setBody(body);
        String methodName = "METHOD_NAME";
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration();
        Assertions.assertThat((List)classOrInterfaceDeclaration.getMethodsByName("METHOD_NAME")).isEmpty();
        CommonCodegenUtils.addMethod((MethodDeclaration)methodTemplate, (ClassOrInterfaceDeclaration)classOrInterfaceDeclaration, (String)"METHOD_NAME");
        Assertions.assertThat((List)classOrInterfaceDeclaration.getMethodsByName("METHOD_NAME")).hasSize(1);
        Assertions.assertThat((Object)((BlockStmt)((MethodDeclaration)classOrInterfaceDeclaration.getMethodsByName("METHOD_NAME").get(0)).getBody().get())).isEqualTo((Object)body);
    }

    @Test
    void getVariableDeclarator() {
        String variableName = "variableName";
        BlockStmt body = new BlockStmt();
        Assertions.assertThat((Optional)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)"variableName")).isNotPresent();
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)"String"), "variableName");
        body.addStatement((Expression)variableDeclarationExpr);
        Optional retrieved = CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)"variableName");
        Assertions.assertThat((Optional)retrieved).isPresent();
        VariableDeclarator variableDeclarator = (VariableDeclarator)retrieved.get();
        Assertions.assertThat((String)variableDeclarator.getName().asString()).isEqualTo("variableName");
    }

    @Test
    void getExpressionForObject() {
        String string = "string";
        Expression retrieved = CommonCodegenUtils.getExpressionForObject((Object)string);
        Assertions.assertThat((Object)retrieved).isInstanceOf(StringLiteralExpr.class);
        Assertions.assertThat((String)retrieved.toString()).isEqualTo("\"string\"");
        int i = 1;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)i);
        Assertions.assertThat((Object)retrieved).isInstanceOf(IntegerLiteralExpr.class);
        Assertions.assertThat((int)((IntegerLiteralExpr)retrieved).asInt()).isEqualTo(i);
        Integer j = 3;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)j);
        Assertions.assertThat((Object)retrieved).isInstanceOf(IntegerLiteralExpr.class);
        Assertions.assertThat((int)((IntegerLiteralExpr)retrieved).asInt()).isEqualTo(j.intValue());
        double x = 1.12;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)x);
        Assertions.assertThat((Object)retrieved).isInstanceOf(DoubleLiteralExpr.class);
        Assertions.assertThat((double)((DoubleLiteralExpr)retrieved).asDouble()).isCloseTo(x, Offset.offset((Number)0.001));
        Double y = 3.12;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)y);
        Assertions.assertThat((Object)retrieved).isInstanceOf(DoubleLiteralExpr.class);
        Assertions.assertThat((double)((DoubleLiteralExpr)retrieved).asDouble()).isCloseTo(y, Offset.offset((Number)0.001));
        float k = 1.12f;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)Float.valueOf(k));
        Assertions.assertThat((Object)retrieved).isInstanceOf(DoubleLiteralExpr.class);
        Assertions.assertThat((double)((DoubleLiteralExpr)retrieved).asDouble()).isCloseTo(1.12, Offset.offset((Number)0.001));
        Float z = Float.valueOf(3.12f);
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)z);
        Assertions.assertThat((Object)retrieved).isInstanceOf(DoubleLiteralExpr.class);
        Assertions.assertThat((double)((DoubleLiteralExpr)retrieved).asDouble()).isCloseTo(z.doubleValue(), Offset.offset((Number)0.001));
        boolean b = true;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)b);
        Assertions.assertThat((Object)retrieved).isInstanceOf(BooleanLiteralExpr.class);
        Assertions.assertThat((boolean)((BooleanLiteralExpr)retrieved).getValue()).isEqualTo(b);
        Boolean c = false;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)c);
        Assertions.assertThat((Object)retrieved).isInstanceOf(BooleanLiteralExpr.class);
        Assertions.assertThat((boolean)((BooleanLiteralExpr)retrieved).getValue()).isEqualTo((Object)c);
    }

    @Test
    void getNameExprsFromBlock() {
        BlockStmt toRead = new BlockStmt();
        List retrieved = CommonCodegenUtils.getNameExprsFromBlock((BlockStmt)toRead, (String)"value");
        Assertions.assertThat((List)retrieved).isNotNull();
        Assertions.assertThat((List)retrieved).isEmpty();
        toRead = this.getBlockStmt();
        retrieved = CommonCodegenUtils.getNameExprsFromBlock((BlockStmt)toRead, (String)"value");
        Assertions.assertThat((List)retrieved).isNotNull();
        Assertions.assertThat((List)retrieved).hasSize(2);
    }

    @Test
    void literalExprFromDataType() {
        HashMap<DATA_TYPE, String> inputMap = new HashMap<DATA_TYPE, String>();
        inputMap.put(DATA_TYPE.STRING, "TEST");
        inputMap.put(DATA_TYPE.INTEGER, "1");
        inputMap.put(DATA_TYPE.FLOAT, "2.0");
        inputMap.put(DATA_TYPE.DOUBLE, "3.0");
        inputMap.put(DATA_TYPE.BOOLEAN, "true");
        inputMap.put(DATA_TYPE.DATE, "2021-06-01");
        inputMap.put(DATA_TYPE.TIME, "11:21:31");
        inputMap.put(DATA_TYPE.DATE_TIME, "2021-06-01T11:21:31");
        inputMap.put(DATA_TYPE.DATE_DAYS_SINCE_0, "10");
        inputMap.put(DATA_TYPE.DATE_DAYS_SINCE_1960, "20");
        inputMap.put(DATA_TYPE.DATE_DAYS_SINCE_1970, "30");
        inputMap.put(DATA_TYPE.DATE_DAYS_SINCE_1980, "40");
        inputMap.put(DATA_TYPE.TIME_SECONDS, "50");
        inputMap.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_0, "60");
        inputMap.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1960, "70");
        inputMap.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1970, "80");
        inputMap.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1980, "90");
        for (Map.Entry input : inputMap.entrySet()) {
            Assertions.assertThat((Object)CommonCodegenUtils.literalExprFrom((DATA_TYPE)((DATA_TYPE)input.getKey()), null)).isInstanceOf(NullLiteralExpr.class);
            Expression output = CommonCodegenUtils.literalExprFrom((DATA_TYPE)((DATA_TYPE)input.getKey()), (String)((String)input.getValue()));
            switch ((DATA_TYPE)input.getKey()) {
                case STRING: {
                    Assertions.assertThat((Object)output).isInstanceOf(StringLiteralExpr.class);
                    break;
                }
                case INTEGER: {
                    Assertions.assertThat((Object)output).isInstanceOf(IntegerLiteralExpr.class);
                    break;
                }
                case DOUBLE: 
                case FLOAT: {
                    Assertions.assertThat((Object)output).isInstanceOf(DoubleLiteralExpr.class);
                    break;
                }
                case BOOLEAN: {
                    Assertions.assertThat((Object)output).isInstanceOf(BooleanLiteralExpr.class);
                    break;
                }
                case DATE: 
                case TIME: 
                case DATE_TIME: {
                    Assertions.assertThat((Object)output).isInstanceOf(MethodCallExpr.class);
                    break;
                }
                case DATE_DAYS_SINCE_0: 
                case DATE_DAYS_SINCE_1960: 
                case DATE_DAYS_SINCE_1970: 
                case DATE_DAYS_SINCE_1980: 
                case TIME_SECONDS: 
                case DATE_TIME_SECONDS_SINCE_0: 
                case DATE_TIME_SECONDS_SINCE_1960: 
                case DATE_TIME_SECONDS_SINCE_1970: 
                case DATE_TIME_SECONDS_SINCE_1980: {
                    Assertions.assertThat((Object)output).isInstanceOf(LongLiteralExpr.class);
                }
            }
        }
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> CommonCodegenUtils.literalExprFrom(null, null));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> CommonCodegenUtils.literalExprFrom(null, (String)"test"));
    }

    @Test
    void replaceNodesInBlock() {
        BlockStmt toRead = this.getBlockStmt();
        List retrieved = CommonCodegenUtils.getNameExprsFromBlock((BlockStmt)toRead, (String)"value");
        Assertions.assertThat((List)retrieved).hasSize(2);
        List<NullLiteralExpr> nullExprs = toRead.stream().filter(node -> node instanceof NullLiteralExpr).map(NullLiteralExpr.class::cast).collect(Collectors.toList());
        Assertions.assertThat(nullExprs).isNotNull();
        Assertions.assertThat(nullExprs).isEmpty();
        List replacementTuples = retrieved.stream().map(nameExpr -> {
            NullLiteralExpr toAdd = new NullLiteralExpr();
            nullExprs.add(toAdd);
            return new CommonCodegenUtils.ReplacementTuple((Node)nameExpr, (Node)toAdd);
        }).collect(Collectors.toList());
        CommonCodegenUtils.replaceNodesInStatement((Statement)toRead, replacementTuples);
        List newRetrieved = CommonCodegenUtils.getNameExprsFromBlock((BlockStmt)toRead, (String)"value");
        Assertions.assertThat((List)newRetrieved).isEmpty();
        List retrievedNullExprs = toRead.stream().filter(node -> node instanceof NullLiteralExpr).map(NullLiteralExpr.class::cast).collect(Collectors.toList());
        Assertions.assertThat(nullExprs).isNotNull();
        Assertions.assertThat(retrievedNullExprs).hasSameSizeAs(nullExprs);
        nullExprs.forEach(nullExpr -> Assertions.assertThat((List)retrievedNullExprs).contains((Object[])new NullLiteralExpr[]{nullExpr}));
    }

    private BlockStmt getBlockStmt() {
        String blockStatement = "{\nObject inputValue = 12;\n        if (stringObjectMap.containsKey(\"avalue\")) {\n            inputValue = stringObjectMap.get(\"avalue\");\n        } else {\n            return false;\n        }\n        if (inputValue instanceof Number && value instanceof Number) {\n            return ((Number) inputValue).doubleValue() >= ((Number) value).doubleValue();\n        } else {\n            return false;\n        }\n}";
        return StaticJavaParser.parseBlock((String)blockStatement);
    }

    private void commonValidateMethodDeclaration(MethodDeclaration toValidate, String methodName) {
        Assertions.assertThat((Object)toValidate).isNotNull();
        Assertions.assertThat((String)toValidate.getName().asString()).isEqualTo(methodName);
    }

    private void commonValidateMethodDeclarationParams(MethodDeclaration toValidate, Map<String, ClassOrInterfaceType> parameterNameTypeMap) {
        NodeList retrieved = toValidate.getParameters();
        Assertions.assertThat((List)retrieved).isNotNull();
        Assertions.assertThat((List)retrieved).hasSize(parameterNameTypeMap.size());
        for (Parameter parameter : retrieved) {
            Assertions.assertThat(parameterNameTypeMap).containsKey((Object)parameter.getNameAsString());
            Assertions.assertThat((Object)parameter.getType()).isEqualTo((Object)parameterNameTypeMap.get(parameter.getNameAsString()));
        }
    }

    private MethodDeclaration getMethodDeclaration(String methodName) {
        return CommonCodegenUtils.getMethodDeclaration((String)methodName);
    }
}

