/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.TransformationDictionary;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLTransformationDictionary;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.factories.InstanceFactoriesTestCommon;
import org.kie.pmml.compiler.commons.factories.KiePMMLTransformationDictionaryInstanceFactory;

public class KiePMMLTransformationDictionaryInstanceFactoryTest {
    @Test
    void getKiePMMLTransformationDictionary() {
        TransformationDictionary toConvert = PMMLModelTestUtils.getRandomTransformationDictionary();
        KiePMMLTransformationDictionary retrieved = KiePMMLTransformationDictionaryInstanceFactory.getKiePMMLTransformationDictionary((TransformationDictionary)toConvert, Collections.emptyList());
        Assertions.assertThat((Object)retrieved).isNotNull();
        List derivedFields = toConvert.getDerivedFields();
        List derivedFieldsToVerify = retrieved.getDerivedFields();
        Assertions.assertThat((List)derivedFieldsToVerify).hasSameSizeAs((Iterable)derivedFields);
        derivedFields.forEach(derivedFieldSource -> {
            Optional<KiePMMLDerivedField> derivedFieldToVerify = derivedFieldsToVerify.stream().filter(param -> param.getName().equals(derivedFieldSource.getName())).findFirst();
            Assertions.assertThat(derivedFieldToVerify).isPresent();
            InstanceFactoriesTestCommon.commonVerifyKiePMMLDerivedField(derivedFieldToVerify.get(), derivedFieldSource);
        });
        List defineFunctions = toConvert.getDefineFunctions();
        List defineFunctionsToVerify = retrieved.getDefineFunctions();
        Assertions.assertThat((List)defineFunctionsToVerify).hasSameSizeAs((Iterable)defineFunctions);
        defineFunctions.forEach(defineFunctionSource -> {
            Optional<KiePMMLDefineFunction> defineFunctionToVerify = defineFunctionsToVerify.stream().filter(param -> param.getName().equals(defineFunctionSource.getName())).findFirst();
            Assertions.assertThat(defineFunctionToVerify).isPresent();
            InstanceFactoriesTestCommon.commonVerifyKiePMMLDefineFunction(defineFunctionToVerify.get(), defineFunctionSource);
        });
    }
}

