/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.testutils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodegenTestUtils.class);

    public static void commonValidateCompilation(BlockStmt body, List<Parameter> parameters) {
        ClassOrInterfaceDeclaration classOrInterfaceType = new ClassOrInterfaceDeclaration();
        classOrInterfaceType.setName("CommCodeTest");
        MethodDeclaration toAdd = new MethodDeclaration();
        toAdd.setType("void");
        toAdd.setName("TestingMethod");
        toAdd.setParameters(NodeList.nodeList(parameters));
        toAdd.setBody(body);
        classOrInterfaceType.addMember((BodyDeclaration)toAdd);
        CompilationUnit compilationUnit = StaticJavaParser.parse((String)"");
        compilationUnit.setPackageDeclaration("org.kie.pmml.compiler.commons.utils");
        compilationUnit.addType((TypeDeclaration)classOrInterfaceType);
        Map<String, String> sourcesMap = Collections.singletonMap("org.kie.pmml.compiler.commons.utils.CommCodeTest", compilationUnit.toString());
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    public static void commonValidateCompilationWithImports(Expression expression, List<Class<?>> imports) {
        BlockStmt body = new BlockStmt();
        body.addStatement(expression);
        CodegenTestUtils.commonValidateCompilationWithImports(body, imports);
    }

    public static void commonValidateCompilationWithImports(BlockStmt body, List<Class<?>> imports) {
        ClassOrInterfaceDeclaration classOrInterfaceType = new ClassOrInterfaceDeclaration();
        classOrInterfaceType.setName("CommCodeTest");
        MethodDeclaration toAdd = new MethodDeclaration();
        toAdd.setType("void");
        toAdd.setName("TestingMethod");
        toAdd.setParameters(NodeList.nodeList((Node[])new Parameter[0]));
        toAdd.setBody(body);
        classOrInterfaceType.addMember((BodyDeclaration)toAdd);
        CompilationUnit compilationUnit = StaticJavaParser.parse((String)"");
        imports.forEach(arg_0 -> ((CompilationUnit)compilationUnit).addImport(arg_0));
        compilationUnit.setPackageDeclaration("org.kie.pmml.compiler.commons.utils");
        compilationUnit.addType((TypeDeclaration)classOrInterfaceType);
        Map<String, String> sourcesMap = Collections.singletonMap("org.kie.pmml.compiler.commons.utils.CommCodeTest", compilationUnit.toString());
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    public static void commonValidateCompilation(MethodDeclaration methodDeclaration) {
        ClassOrInterfaceDeclaration classOrInterfaceType = new ClassOrInterfaceDeclaration();
        classOrInterfaceType.setName("CommCodeTest");
        classOrInterfaceType.addMember((BodyDeclaration)methodDeclaration);
        CompilationUnit compilationUnit = StaticJavaParser.parse((String)"");
        compilationUnit.setPackageDeclaration("org.kie.pmml.compiler.commons.utils");
        compilationUnit.addType((TypeDeclaration)classOrInterfaceType);
        Map<String, String> sourcesMap = Collections.singletonMap("org.kie.pmml.compiler.commons.utils.CommCodeTest", compilationUnit.toString());
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    public static void commonValidateCompilationWithImports(MethodDeclaration methodDeclaration, List<Class<?>> imports) {
        ClassOrInterfaceDeclaration classOrInterfaceType = new ClassOrInterfaceDeclaration();
        classOrInterfaceType.setName("CommCodeTest");
        classOrInterfaceType.addMember((BodyDeclaration)methodDeclaration);
        CompilationUnit compilationUnit = StaticJavaParser.parse((String)"");
        imports.forEach(arg_0 -> ((CompilationUnit)compilationUnit).addImport(arg_0));
        compilationUnit.setPackageDeclaration("org.kie.pmml.compiler.commons.utils");
        compilationUnit.addType((TypeDeclaration)classOrInterfaceType);
        Map<String, String> sourcesMap = Collections.singletonMap("org.kie.pmml.compiler.commons.utils.CommCodeTest", compilationUnit.toString());
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    public static void commonValidateCompilationWithImports(ClassOrInterfaceDeclaration classOrInterfaceType, List<Class<?>> imports) {
        CompilationUnit compilationUnit = StaticJavaParser.parse((String)"");
        imports.forEach(arg_0 -> ((CompilationUnit)compilationUnit).addImport(arg_0));
        compilationUnit.setPackageDeclaration("org.kie.pmml.compiler.commons.utils");
        compilationUnit.addType((TypeDeclaration)classOrInterfaceType);
        Map<CallSite, String> sourcesMap = Collections.singletonMap("org.kie.pmml.compiler.commons.utils." + classOrInterfaceType.getName().asString(), compilationUnit.toString());
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    public static void commonValidateCompilation(Map<String, String> sourcesMap) {
        try {
            KieMemoryCompiler.compile(sourcesMap, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    public static boolean commonEvaluateConstructor(ConstructorDeclaration constructorDeclaration, String generatedClassName, Map<Integer, Expression> superInvocationExpressionsMap, Map<String, Expression> assignExpressionsMap) {
        Assertions.assertThat((Object)constructorDeclaration.getName()).isEqualTo((Object)new SimpleName(generatedClassName));
        BlockStmt body = constructorDeclaration.getBody();
        return CodegenTestUtils.commonEvaluateSuperInvocationExpr(body, superInvocationExpressionsMap) && CodegenTestUtils.commonEvaluateAssignExpr(body, assignExpressionsMap);
    }

    public static boolean commonEvaluateSuperInvocationExpr(BlockStmt body, Map<Integer, Expression> superInvocationExpressionsMap) {
        Optional retrieved = CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body);
        ArrayList errors = new ArrayList();
        retrieved.ifPresent(explicitConstructorInvocationStmt -> superInvocationExpressionsMap.forEach((integer, expression) -> {
            try {
                Assertions.assertThat((Object)explicitConstructorInvocationStmt.getArgument(integer.intValue())).isEqualTo(expression);
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).getMessage() != null && !((Throwable)((Object)e)).getMessage().isEmpty()) {
                    LOGGER.error(((Throwable)((Object)e)).getMessage());
                } else {
                    ((Throwable)((Object)e)).printStackTrace();
                }
                errors.add(e);
            }
        }));
        return errors.isEmpty();
    }

    public static boolean commonEvaluateAssignExpr(BlockStmt blockStmt, Map<String, Expression> assignExpressionMap) {
        List retrieved = blockStmt.findAll(AssignExpr.class);
        ArrayList<AssertionError> errors = new ArrayList<AssertionError>();
        for (Map.Entry<String, Expression> entry : assignExpressionMap.entrySet()) {
            try {
                Assertions.assertThat((boolean)retrieved.stream().filter(assignExpr -> assignExpr.getTarget().asNameExpr().equals((Object)new NameExpr((String)entry.getKey()))).anyMatch(assignExpr -> assignExpr.getValue().equals(entry.getValue()))).isTrue();
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).getMessage() != null && !((Throwable)((Object)e)).getMessage().isEmpty()) {
                    LOGGER.error(((Throwable)((Object)e)).getMessage());
                } else {
                    ((Throwable)((Object)e)).printStackTrace();
                }
                errors.add(e);
            }
        }
        return errors.isEmpty();
    }
}

