/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.drools.util.FileUtils;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameOpType;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;

public class KiePMMLLoadedModelUtilsTest {
    private static final String NO_TARGET_SOURCE = "NoTargetFieldSample.pmml";
    private static final String ONE_MINING_TARGET_SOURCE = "OneMiningTargetFieldSample.pmml";
    private static final String MULTIPLE_TARGETS_SOURCE = "MultipleTargetsFieldSample.pmml";
    private static final String NO_MODELNAME_SAMPLE_NAME = "NoModelNameSample";
    private static final String NO_MODELNAME_SAMPLE = "NoModelNameSample.pmml";
    private static final String WHAT_I_DO_TARGET_FIELD = "whatIdo";
    private static final String CAR_LOCATION_FIELD = "car_location";
    private static final String NUMBER_OF_CLAIMS_FIELD = "number_of_claims";
    private static final String SALARY_FIELD = "salary";
    private static final String OUTLOOK_FIELD = "outlook";
    private static final String TEMPERATURE_FIELD = "temperature";
    private static final String NOT_EXISTING_FIELD = "not_existing";
    private PMML pmmlModel;

    @Test
    void getTargetFieldNoTarget() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)NO_TARGET_SOURCE), (String)NO_TARGET_SOURCE);
        List fields = CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.pmmlModel.getDataDictionary());
        Assertions.assertThat((Optional)ModelUtils.getTargetFieldName((List)fields, (Model)((Model)this.pmmlModel.getModels().get(0)))).isPresent();
        Assertions.assertThat((List)ModelUtils.getTargetFields((List)fields, (Model)((Model)this.pmmlModel.getModels().get(0)))).isNotEmpty();
    }

    @Test
    void getTargetFieldOneMiningTarget() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        List fields = CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.pmmlModel.getDataDictionary());
        Optional retrieved = ModelUtils.getTargetFieldName((List)fields, (Model)((Model)this.pmmlModel.getModels().get(0)));
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(WHAT_I_DO_TARGET_FIELD);
        List retrieveds = ModelUtils.getTargetFields((List)fields, (Model)((Model)this.pmmlModel.getModels().get(0)));
        Assertions.assertThat((List)retrieveds).hasSize(1);
        Assertions.assertThat((String)((KiePMMLNameOpType)retrieveds.get(0)).getName()).isEqualTo(WHAT_I_DO_TARGET_FIELD);
    }

    @Test
    void getTargetFieldMultipleTargets() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MULTIPLE_TARGETS_SOURCE), (String)MULTIPLE_TARGETS_SOURCE);
        List fields = CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.pmmlModel.getDataDictionary());
        Optional retrieved = ModelUtils.getTargetFieldName((List)fields, (Model)((Model)this.pmmlModel.getModels().get(0)));
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(CAR_LOCATION_FIELD);
        List retrieveds = ModelUtils.getTargetFields((List)fields, (Model)((Model)this.pmmlModel.getModels().get(0)));
        Assertions.assertThat((List)retrieveds).hasSize(1);
        Assertions.assertThat((String)((KiePMMLNameOpType)retrieveds.get(0)).getName()).isEqualTo(CAR_LOCATION_FIELD);
    }

    @Test
    void getOpTypeFromDataFieldExisting() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)NO_TARGET_SOURCE), (String)NO_TARGET_SOURCE);
        OP_TYPE retrieved = ModelUtils.getOpType((List)CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.pmmlModel.getDataDictionary()), (Model)((Model)this.pmmlModel.getModels().get(0)), (String)TEMPERATURE_FIELD);
        Assertions.assertThat((Comparable)retrieved).isNotNull();
        Assertions.assertThat((Comparable)retrieved).isEqualTo((Object)OP_TYPE.CONTINUOUS);
    }

    @Test
    void getOpTypeFromMiningFieldExisting() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        OP_TYPE retrieved = ModelUtils.getOpType((List)CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.pmmlModel.getDataDictionary()), (Model)((Model)this.pmmlModel.getModels().get(0)), (String)OUTLOOK_FIELD);
        Assertions.assertThat((Comparable)retrieved).isNotNull();
        Assertions.assertThat((Comparable)retrieved).isEqualTo((Object)OP_TYPE.CATEGORICAL);
    }

    @Test
    void getOpTypeNotExistingField() throws Exception {
        AssertionsForClassTypes.assertThatExceptionOfType(KiePMMLInternalException.class).isThrownBy(() -> {
            this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
            ModelUtils.getOpType((List)CommonTestingUtils.getFieldsFromDataDictionary((DataDictionary)this.pmmlModel.getDataDictionary()), (Model)((Model)this.pmmlModel.getModels().get(0)), (String)NOT_EXISTING_FIELD);
        });
    }

    @Test
    void populateMissingModelNames() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)NO_MODELNAME_SAMPLE), (String)NO_MODELNAME_SAMPLE);
        List models = this.pmmlModel.getModels();
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            Assertions.assertThat((String)model.getModelName()).isNotNull();
            Assertions.assertThat((String)model.getModelName()).isNotEmpty();
            String expected = String.format("%s%s%s", NO_MODELNAME_SAMPLE_NAME, model.getClass().getSimpleName(), i);
            Assertions.assertThat((String)model.getModelName()).isEqualTo(expected);
        }
    }
}

