/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLExpressionInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLExtensionInstanceFactory;

public class KiePMMLDerivedFieldInstanceFactory {
    private KiePMMLDerivedFieldInstanceFactory() {
    }

    static List<KiePMMLDerivedField> getKiePMMLDerivedFields(List<DerivedField> derivedFields, List<Field<?>> fields) {
        return derivedFields != null ? derivedFields.stream().map(derivedField -> KiePMMLDerivedFieldInstanceFactory.getKiePMMLDerivedField(derivedField, fields)).collect(Collectors.toList()) : Collections.emptyList();
    }

    static KiePMMLDerivedField getKiePMMLDerivedField(DerivedField derivedField, List<Field<?>> fields) {
        DataType dataType = derivedField.getDataType() != null ? derivedField.getDataType() : ModelUtils.getDataType(fields, (String)derivedField.getName());
        OP_TYPE opType = derivedField.getOpType() != null ? OP_TYPE.byName((String)derivedField.getOpType().value()) : null;
        return (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)derivedField.getName(), KiePMMLExtensionInstanceFactory.getKiePMMLExtensions(derivedField.getExtensions()), (DATA_TYPE)DATA_TYPE.byName((String)dataType.value()), (OP_TYPE)opType, (KiePMMLExpression)KiePMMLExpressionInstanceFactory.getKiePMMLExpression(derivedField.getExpression())).withDisplayName(derivedField.getDisplayName()).build();
    }
}

