/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.enums.DATA_TYPE;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.utils.PrimitiveBoxedUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;

public class ExpressionFunctionUtils {
    static final String KIEPMMLNAMEVALUE_LIST_PARAM = "param1";
    static final String INNER_VARIABLE_NAME = "variable%s%s%s";

    private ExpressionFunctionUtils() {
    }

    static MethodDeclaration getAggregatedExpressionMethodDeclaration(String methodName, Aggregate aggregate, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static MethodDeclaration getApplyExpressionMethodDeclaration(String methodName, Apply apply, List<ClassOrInterfaceType> parameterTypes) {
        String variableName = "applyVariable";
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        BlockStmt body = ExpressionFunctionUtils.getApplyExpressionBlockStmt(variableName, apply, returnedType, parameterTypes);
        return ExpressionFunctionUtils.getExpressionMethodDeclaration(methodName, variableName, body, returnedType, parameterTypes);
    }

    static MethodDeclaration getConstantExpressionMethodDeclaration(String methodName, Constant constant, List<ClassOrInterfaceType> parameterTypes) {
        String variableName = "constantVariable";
        Class returnedTypeClass = constant.getDataType() != null ? DATA_TYPE.byName((String)constant.getDataType().value()).getMappedClass() : constant.getValue().getClass();
        String eventuallyBoxedClass = PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed((Class)returnedTypeClass).map(primitiveBoxed -> primitiveBoxed.getBoxed().getName()).orElse(returnedTypeClass.getName());
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)eventuallyBoxedClass);
        BlockStmt body = ExpressionFunctionUtils.getConstantExpressionBlockStmt(variableName, constant, returnedType, parameterTypes);
        return ExpressionFunctionUtils.getExpressionMethodDeclaration(methodName, variableName, body, returnedType, parameterTypes);
    }

    static MethodDeclaration getDiscretizeExpressionMethodDeclaration(String methodName, Discretize discretize, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static MethodDeclaration getFieldRefExpressionMethodDeclaration(String methodName, FieldRef fieldRef, List<ClassOrInterfaceType> parameterTypes) {
        String variableName = "fieldRefVariable";
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        BlockStmt body = ExpressionFunctionUtils.getFieldRefExpressionBlockStmt(variableName, fieldRef, returnedType, parameterTypes);
        return ExpressionFunctionUtils.getExpressionMethodDeclaration(methodName, variableName, body, returnedType, parameterTypes);
    }

    static MethodDeclaration getLagExpressionMethodDeclaration(String methodName, Lag lag, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static MethodDeclaration getMapValuesExpressionMethodDeclaration(String methodName, MapValues mapValues, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static MethodDeclaration getNormContinuousExpressionMethodDeclaration(String methodName, NormContinuous normContinuous, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static MethodDeclaration getNormDiscreteExpressionMethodDeclaration(String methodName, NormDiscrete normDiscrete, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static MethodDeclaration getTextIndexExpressionMethodDeclaration(String methodName, TextIndex textIndex, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }

    static BlockStmt getExpressionBlockStmt(String variableName, Expression expression, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        if (expression instanceof Aggregate) {
            return ExpressionFunctionUtils.getAggregatedExpressionBlockStmt(variableName, (Aggregate)expression, returnedType, parameterTypes);
        }
        if (expression instanceof Apply) {
            return ExpressionFunctionUtils.getApplyExpressionBlockStmt(variableName, (Apply)expression, returnedType, parameterTypes);
        }
        if (expression instanceof Constant) {
            return ExpressionFunctionUtils.getConstantExpressionBlockStmt(variableName, (Constant)expression, returnedType, parameterTypes);
        }
        if (expression instanceof Discretize) {
            return ExpressionFunctionUtils.getDiscretizeExpressionBlockStmt(variableName, (Discretize)expression, returnedType, parameterTypes);
        }
        if (expression instanceof FieldRef) {
            return ExpressionFunctionUtils.getFieldRefExpressionBlockStmt(variableName, (FieldRef)expression, returnedType, parameterTypes);
        }
        if (expression instanceof Lag) {
            return ExpressionFunctionUtils.getLagExpressionBlockStmt(variableName, (Lag)expression, returnedType, parameterTypes);
        }
        if (expression instanceof MapValues) {
            return ExpressionFunctionUtils.getMapValuesExpressionBlockStmt(variableName, (MapValues)expression, returnedType, parameterTypes);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionFunctionUtils.getNormContinuousExpressionBlockStmt(variableName, (NormContinuous)expression, returnedType, parameterTypes);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionFunctionUtils.getNormDiscreteExpressionBlockStmt(variableName, (NormDiscrete)expression, returnedType, parameterTypes);
        }
        if (expression instanceof TextIndex) {
            return ExpressionFunctionUtils.getTextIndexExpressionBlockStmt(variableName, (TextIndex)expression, returnedType, parameterTypes);
        }
        throw new IllegalArgumentException(String.format("Expression %s not managed", expression.getClass()));
    }

    static BlockStmt getAggregatedExpressionBlockStmt(String variableName, Aggregate aggregate, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static BlockStmt getApplyExpressionBlockStmt(String variableName, Apply apply, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        BlockStmt toReturn = new BlockStmt();
        ArrayList<String> innerVariables = new ArrayList<String>();
        innerVariables.add(KIEPMMLNAMEVALUE_LIST_PARAM);
        ClassOrInterfaceType objectReturnedType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        if (apply.getExpressions() != null) {
            int counter = 1;
            for (Expression expression : apply.getExpressions()) {
                String innerVariable = String.format(INNER_VARIABLE_NAME, variableName, expression.getClass().getSimpleName(), counter);
                BlockStmt innerBlockStmt = ExpressionFunctionUtils.getExpressionBlockStmt(innerVariable, expression, objectReturnedType, parameterTypes);
                toReturn.getStatements().addAll(innerBlockStmt.getStatements());
                innerVariables.add(innerVariable);
                ++counter;
            }
        }
        MethodCallExpr functionMethodCall = new MethodCallExpr();
        functionMethodCall.setScope((com.github.javaparser.ast.expr.Expression)new ThisExpr());
        functionMethodCall.setName(apply.getFunction());
        NodeList functionCallArguments = NodeList.nodeList((Collection)innerVariables.stream().map(NameExpr::new).collect(Collectors.toList()));
        functionMethodCall.setArguments(functionCallArguments);
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        variableDeclarator.setType((Type)classOrInterfaceType);
        variableDeclarator.setName(variableName);
        variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)functionMethodCall);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr();
        variableDeclarationExpr.setVariables(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        toReturn.addStatement((com.github.javaparser.ast.expr.Expression)variableDeclarationExpr);
        return toReturn;
    }

    static BlockStmt getConstantExpressionBlockStmt(String variableName, Constant constant, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        BlockStmt toReturn = new BlockStmt();
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setName(variableName);
        Object constantValue = constant.getValue();
        if (constantValue instanceof String) {
            variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)new StringLiteralExpr((String)constantValue));
        } else {
            variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)new NameExpr(constantValue.toString()));
        }
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr();
        variableDeclarationExpr.setVariables(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        toReturn.addStatement((com.github.javaparser.ast.expr.Expression)variableDeclarationExpr);
        return toReturn;
    }

    static BlockStmt getDiscretizeExpressionBlockStmt(String variableName, Discretize discretize, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static BlockStmt getFieldRefExpressionBlockStmt(String variableName, FieldRef fieldRef, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        BlockStmt toReturn = new BlockStmt();
        String fieldNameToRef = fieldRef.getField().getValue();
        ExpressionStmt filteredOptionalExpr = CommonCodegenUtils.getFilteredKiePMMLNameValueExpression(KIEPMMLNAMEVALUE_LIST_PARAM, fieldNameToRef);
        toReturn.addStatement((Statement)filteredOptionalExpr);
        MethodReferenceExpr methodReferenceExpr = new MethodReferenceExpr();
        methodReferenceExpr.setScope((com.github.javaparser.ast.expr.Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)KiePMMLNameValue.class.getName())));
        methodReferenceExpr.setIdentifier("getValue");
        MethodCallExpr expressionScope = new MethodCallExpr("map", new com.github.javaparser.ast.expr.Expression[0]);
        expressionScope.setScope((com.github.javaparser.ast.expr.Expression)new NameExpr(CommonCodegenUtils.OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME));
        expressionScope.setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{methodReferenceExpr}));
        MethodCallExpr expression = new MethodCallExpr("orElse", new com.github.javaparser.ast.expr.Expression[0]);
        expression.setScope((com.github.javaparser.ast.expr.Expression)expressionScope);
        StringLiteralExpr orElseExpression = fieldRef.getMapMissingTo() != null ? new StringLiteralExpr(fieldRef.getMapMissingTo()) : new NullLiteralExpr();
        expression.setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{orElseExpression}));
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        variableDeclarator.setType((Type)classOrInterfaceType);
        variableDeclarator.setName(variableName);
        variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)expression);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr();
        variableDeclarationExpr.setVariables(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        toReturn.addStatement((com.github.javaparser.ast.expr.Expression)variableDeclarationExpr);
        return toReturn;
    }

    static BlockStmt getLagExpressionBlockStmt(String variableName, Lag lag, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static BlockStmt getMapValuesExpressionBlockStmt(String variableName, MapValues mapValues, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static BlockStmt getNormContinuousExpressionBlockStmt(String variableName, NormContinuous normContinuous, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static BlockStmt getNormDiscreteExpressionBlockStmt(String variableName, NormDiscrete normDiscrete, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static BlockStmt getTextIndexExpressionBlockStmt(String variableName, TextIndex textIndex, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }

    static MethodDeclaration getExpressionMethodDeclaration(String methodName, String variableName, BlockStmt body, ClassOrInterfaceType returnedType, List<ClassOrInterfaceType> parameterTypes) {
        ReturnStmt returnStmt = CommonCodegenUtils.getReturnStmt(variableName);
        body.addStatement((Statement)returnStmt);
        MethodDeclaration toReturn = CommonCodegenUtils.getMethodDeclaration(methodName, parameterTypes);
        toReturn.setType((Type)returnedType);
        toReturn.setBody(body);
        return toReturn;
    }
}

