/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.DefineFunctionUtils;
import org.kie.pmml.compiler.commons.utils.DerivedFieldFunctionUtils;

public class KiePMMLModelFactoryUtils {
    private KiePMMLModelFactoryUtils() {
    }

    public static void addTransformationsInClassOrInterfaceDeclaration(ClassOrInterfaceDeclaration toPopulate, TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        AtomicInteger arityCounter = new AtomicInteger(0);
        Map<String, MethodDeclaration> commonDerivedFieldsMethodMap = transformationDictionary != null && transformationDictionary.getDerivedFields() != null ? DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(transformationDictionary.getDerivedFields(), arityCounter) : Collections.emptyMap();
        Map<String, MethodDeclaration> localDerivedFieldsMethodMap = localTransformations != null && localTransformations.getDerivedFields() != null ? DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(localTransformations.getDerivedFields(), arityCounter) : Collections.emptyMap();
        Map defineFunctionsMethodMap = transformationDictionary != null && transformationDictionary.getDefineFunctions() != null ? DefineFunctionUtils.getDefineFunctionsMethodMap(transformationDictionary.getDefineFunctions()) : Collections.emptyMap();
        CommonCodegenUtils.populateMethodDeclarations(toPopulate, commonDerivedFieldsMethodMap.values());
        CommonCodegenUtils.populateMethodDeclarations(toPopulate, localDerivedFieldsMethodMap.values());
        CommonCodegenUtils.populateMethodDeclarations(toPopulate, defineFunctionsMethodMap.values());
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)toPopulate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", toPopulate.getName())));
        KiePMMLModelFactoryUtils.populateTransformationsInConstructor(constructorDeclaration, commonDerivedFieldsMethodMap, localDerivedFieldsMethodMap);
    }

    static void populateTransformationsInConstructor(ConstructorDeclaration constructorDeclaration, Map<String, MethodDeclaration> commonDerivedFieldsMethodMap, Map<String, MethodDeclaration> localDerivedFieldsMethodMap) {
        CommonCodegenUtils.addMapPopulation(commonDerivedFieldsMethodMap, constructorDeclaration.getBody(), "commonTransformationsMap");
        CommonCodegenUtils.addMapPopulation(localDerivedFieldsMethodMap, constructorDeclaration.getBody(), "localTransformationsMap");
    }
}

