/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.model.PMMLUtil;
import org.xml.sax.SAXException;

public class KiePMMLUtil {
    static final String MODELNAME_TEMPLATE = "%s%s%s";

    private KiePMMLUtil() {
    }

    public static PMML load(String source) throws SAXException, JAXBException {
        return KiePMMLUtil.load(new ByteArrayInputStream(source.getBytes()), "");
    }

    public static PMML load(InputStream is, String fileName) throws SAXException, JAXBException {
        PMML toReturn = PMMLUtil.unmarshal((InputStream)is);
        String cleanedFileName = fileName.contains(".") ? fileName.substring(0, fileName.indexOf(46)) : fileName;
        KiePMMLUtil.populateMissingModelNames(toReturn, cleanedFileName);
        return toReturn;
    }

    static void populateMissingModelNames(PMML toPopulate, String fileName) {
        List models = toPopulate.getModels();
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            if (model.getModelName() != null && !model.getModelName().isEmpty()) continue;
            String modelName = String.format(MODELNAME_TEMPLATE, fileName, model.getClass().getSimpleName(), i);
            model.setModelName(modelName);
        }
    }
}

