/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;

public class DefineFunctionUtils {
    private DefineFunctionUtils() {
    }

    static Map<String, MethodDeclaration> getDefineFunctionsMethodMap(List<DefineFunction> defineFunctions) {
        HashMap<String, MethodDeclaration> toReturn = new HashMap<String, MethodDeclaration>();
        defineFunctions.forEach(defineFunction -> toReturn.put(defineFunction.getName(), DefineFunctionUtils.getDefineFunctionMethodDeclaration(defineFunction)));
        return toReturn;
    }

    static MethodDeclaration getDefineFunctionMethodDeclaration(DefineFunction defineFunction) {
        Expression expression = defineFunction.getExpression();
        if (expression != null) {
            return DefineFunctionUtils.getExpressionMethodDeclaration(defineFunction.getName(), expression, defineFunction.getParameterFields());
        }
        throw new KiePMMLException("Define Function without Expression are not supported, yet");
    }

    static MethodDeclaration getExpressionMethodDeclaration(String methodName, Expression expression, List<ParameterField> parameterFields) {
        List<ClassOrInterfaceType> parametersClassOrInterfaces = DefineFunctionUtils.getClassOrInterfaceTypes(parameterFields);
        parametersClassOrInterfaces.add(0, CommonCodegenUtils.getTypedClassOrInterfaceType(List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName())));
        if (expression instanceof Aggregate) {
            return DefineFunctionUtils.getAggregatedMethodDeclaration(methodName, (Aggregate)expression, parametersClassOrInterfaces);
        }
        if (expression instanceof Apply) {
            return DefineFunctionUtils.getApplyMethodDeclaration(methodName, (Apply)expression, parametersClassOrInterfaces);
        }
        if (expression instanceof Constant) {
            return DefineFunctionUtils.getConstantMethodDeclaration(methodName, (Constant)expression, parametersClassOrInterfaces);
        }
        if (expression instanceof Discretize) {
            return DefineFunctionUtils.getDiscretizeMethodDeclaration(methodName, (Discretize)expression, parametersClassOrInterfaces);
        }
        if (expression instanceof FieldRef) {
            return DefineFunctionUtils.getFieldRefMethodDeclaration(methodName, (FieldRef)expression, parametersClassOrInterfaces);
        }
        if (expression instanceof Lag) {
            return DefineFunctionUtils.getLagMethodDeclaration(methodName, (Lag)expression, parametersClassOrInterfaces);
        }
        if (expression instanceof MapValues) {
            return DefineFunctionUtils.getMapValuesMethodDeclaration(methodName, (MapValues)expression, parametersClassOrInterfaces);
        }
        if (expression instanceof NormContinuous) {
            return DefineFunctionUtils.getNormContinuousMethodDeclaration(methodName, (NormContinuous)expression, parametersClassOrInterfaces);
        }
        if (expression instanceof NormDiscrete) {
            return DefineFunctionUtils.getNormDiscreteMethodDeclaration(methodName, (NormDiscrete)expression, parametersClassOrInterfaces);
        }
        if (expression instanceof TextIndex) {
            return DefineFunctionUtils.getTextIndexMethodDeclaration(methodName, (TextIndex)expression, parametersClassOrInterfaces);
        }
        throw new IllegalArgumentException(String.format("Expression %s not managed", expression.getClass()));
    }

    static MethodDeclaration getAggregatedMethodDeclaration(String methodName, Aggregate aggregate, List<ClassOrInterfaceType> parameterFields) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static MethodDeclaration getApplyMethodDeclaration(String methodName, Apply apply, List<ClassOrInterfaceType> parameterFields) {
        return ExpressionFunctionUtils.getApplyExpressionMethodDeclaration(methodName, apply, parameterFields);
    }

    static MethodDeclaration getConstantMethodDeclaration(String methodName, Constant constant, List<ClassOrInterfaceType> parameterFields) {
        return ExpressionFunctionUtils.getConstantExpressionMethodDeclaration(methodName, constant, parameterFields);
    }

    static MethodDeclaration getDiscretizeMethodDeclaration(String methodName, Discretize discretize, List<ClassOrInterfaceType> parameterFields) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static MethodDeclaration getFieldRefMethodDeclaration(String methodName, FieldRef fieldRef, List<ClassOrInterfaceType> parameterFields) {
        return ExpressionFunctionUtils.getFieldRefExpressionMethodDeclaration(methodName, fieldRef, parameterFields);
    }

    static MethodDeclaration getLagMethodDeclaration(String methodName, Lag lag, List<ClassOrInterfaceType> parameterFields) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static MethodDeclaration getMapValuesMethodDeclaration(String methodName, MapValues mapValues, List<ClassOrInterfaceType> parameterFields) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static MethodDeclaration getNormContinuousMethodDeclaration(String methodName, NormContinuous normContinuous, List<ClassOrInterfaceType> parameterFields) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static MethodDeclaration getNormDiscreteMethodDeclaration(String methodName, NormDiscrete normDiscrete, List<ClassOrInterfaceType> parameterFields) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static MethodDeclaration getTextIndexMethodDeclaration(String methodName, TextIndex textIndex, List<ClassOrInterfaceType> parameterFields) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }

    static List<ClassOrInterfaceType> getClassOrInterfaceTypes(List<ParameterField> parameterFields) {
        ArrayList<ClassOrInterfaceType> toReturn = new ArrayList<ClassOrInterfaceType>();
        if (parameterFields != null) {
            parameterFields.forEach(parameterField -> toReturn.add(StaticJavaParser.parseClassOrInterfaceType((String)ModelUtils.getBoxedClassName(parameterField))));
        }
        return toReturn;
    }
}

