/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;

public class DerivedFieldFunctionUtils {
    private DerivedFieldFunctionUtils() {
    }

    static Map<String, MethodDeclaration> getDerivedFieldsMethodMap(List<DerivedField> derivedFields, AtomicInteger arityCounter) {
        HashMap<String, MethodDeclaration> toReturn = new HashMap<String, MethodDeclaration>();
        derivedFields.forEach(derivedField -> toReturn.put(derivedField.getName().getValue(), DerivedFieldFunctionUtils.getDerivedFieldMethodDeclaration(derivedField, arityCounter)));
        return toReturn;
    }

    static MethodDeclaration getDerivedFieldMethodDeclaration(DerivedField derivedField, AtomicInteger arityCounter) {
        Expression expression = derivedField.getExpression();
        if (expression != null) {
            return DerivedFieldFunctionUtils.getExpressionMethodDeclaration(expression, arityCounter);
        }
        throw new KiePMMLException("Derived field without Expression are not supported, yet");
    }

    static MethodDeclaration getExpressionMethodDeclaration(Expression expression, AtomicInteger arityCounter) {
        int methodArity = arityCounter.addAndGet(1);
        if (expression instanceof Aggregate) {
            return DerivedFieldFunctionUtils.getAggregatedMethodDeclaration((Aggregate)expression, methodArity);
        }
        if (expression instanceof Apply) {
            return DerivedFieldFunctionUtils.getApplyMethodDeclaration((Apply)expression, methodArity);
        }
        if (expression instanceof Constant) {
            return DerivedFieldFunctionUtils.getConstantMethodDeclaration((Constant)expression, methodArity);
        }
        if (expression instanceof Discretize) {
            return DerivedFieldFunctionUtils.getDiscretizeMethodDeclaration((Discretize)expression, methodArity);
        }
        if (expression instanceof FieldRef) {
            return DerivedFieldFunctionUtils.getFieldRefMethodDeclaration((FieldRef)expression, methodArity);
        }
        if (expression instanceof Lag) {
            return DerivedFieldFunctionUtils.getLagMethodDeclaration((Lag)expression, methodArity);
        }
        if (expression instanceof MapValues) {
            return DerivedFieldFunctionUtils.getMapValuesMethodDeclaration((MapValues)expression, methodArity);
        }
        if (expression instanceof NormContinuous) {
            return DerivedFieldFunctionUtils.getNormContinuousMethodDeclaration((NormContinuous)expression, methodArity);
        }
        if (expression instanceof NormDiscrete) {
            return DerivedFieldFunctionUtils.getNormDiscreteMethodDeclaration((NormDiscrete)expression, methodArity);
        }
        if (expression instanceof TextIndex) {
            return DerivedFieldFunctionUtils.getTextIndexMethodDeclaration((TextIndex)expression, methodArity);
        }
        throw new IllegalArgumentException(String.format("Expression %s not managed", expression.getClass()));
    }

    static MethodDeclaration getAggregatedMethodDeclaration(Aggregate aggregate, int methodArity) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static MethodDeclaration getApplyMethodDeclaration(Apply apply, int methodArity) {
        String methodName = String.format("%s%s", apply.getClass().getSimpleName(), methodArity);
        return ExpressionFunctionUtils.getApplyExpressionMethodDeclaration(methodName, apply, Collections.singletonList(CommonCodegenUtils.getTypedClassOrInterfaceType(List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName()))));
    }

    static MethodDeclaration getConstantMethodDeclaration(Constant constant, int methodArity) {
        String methodName = String.format("%s%s", constant.getClass().getSimpleName(), methodArity);
        return ExpressionFunctionUtils.getConstantExpressionMethodDeclaration(methodName, constant, Collections.singletonList(CommonCodegenUtils.getTypedClassOrInterfaceType(List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName()))));
    }

    static MethodDeclaration getDiscretizeMethodDeclaration(Discretize discretize, int methodArity) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static MethodDeclaration getFieldRefMethodDeclaration(FieldRef fieldRef, int methodArity) {
        String methodName = String.format("%s%s", fieldRef.getClass().getSimpleName(), methodArity);
        return ExpressionFunctionUtils.getFieldRefExpressionMethodDeclaration(methodName, fieldRef, Collections.singletonList(CommonCodegenUtils.getTypedClassOrInterfaceType(List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName()))));
    }

    static MethodDeclaration getLagMethodDeclaration(Lag lag, int methodArity) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static MethodDeclaration getMapValuesMethodDeclaration(MapValues mapValues, int methodArity) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static MethodDeclaration getNormContinuousMethodDeclaration(NormContinuous normContinuous, int methodArity) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static MethodDeclaration getNormDiscreteMethodDeclaration(NormDiscrete normDiscrete, int methodArity) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static MethodDeclaration getTextIndexMethodDeclaration(TextIndex textIndex, int methodArity) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }
}

