/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public class CommonCodegenUtils {
    public static String OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME = "kiePMMLNameValue";
    static final String LAMBDA_PARAMETER_NAME = "lmbdParam";
    static final String METHOD_NAME_TEMPLATE = "%s%s";
    static final String PARAMETER_NAME_TEMPLATE = "param%s";

    private CommonCodegenUtils() {
    }

    public static void populateMethodDeclarations(ClassOrInterfaceDeclaration toPopulate, Collection<MethodDeclaration> methodDeclarations) {
        methodDeclarations.forEach(arg_0 -> ((ClassOrInterfaceDeclaration)toPopulate).addMember(arg_0));
    }

    public static ExpressionStmt getFilteredKiePMMLNameValueExpression(String kiePMMLNameValueListParam, String fieldNameToRef, boolean stringLiteralComparison) {
        MethodCallExpr argumentBodyExpressionArgument2 = new MethodCallExpr("getName", new Expression[0]);
        argumentBodyExpressionArgument2.setScope((Expression)new NameExpr(LAMBDA_PARAMETER_NAME));
        MethodCallExpr argumentBodyExpression = new MethodCallExpr("equals", new Expression[0]);
        Object equalsComparisonExpression = stringLiteralComparison ? new StringLiteralExpr(fieldNameToRef) : new NameExpr(fieldNameToRef);
        argumentBodyExpression.setArguments(NodeList.nodeList((Node[])new Expression[]{equalsComparisonExpression, argumentBodyExpressionArgument2}));
        argumentBodyExpression.setScope((Expression)new NameExpr(Objects.class.getName()));
        ExpressionStmt argumentBody = new ExpressionStmt((Expression)argumentBodyExpression);
        Parameter argumentParameter = new Parameter((Type)StaticJavaParser.parseClassOrInterfaceType((String)KiePMMLNameValue.class.getName()), LAMBDA_PARAMETER_NAME);
        LambdaExpr argument = new LambdaExpr();
        argument.setEnclosingParameters(true).setParameters(NodeList.nodeList((Node[])new Parameter[]{argumentParameter}));
        argument.setBody((Statement)argumentBody);
        MethodCallExpr initializerScopeScope = new MethodCallExpr("stream", new Expression[0]);
        initializerScopeScope.setScope((Expression)new NameExpr(kiePMMLNameValueListParam));
        MethodCallExpr initializerScope = new MethodCallExpr("filter", new Expression[0]);
        initializerScope.setScope((Expression)initializerScopeScope);
        initializerScope.setArguments(NodeList.nodeList((Node[])new Expression[]{argument}));
        MethodCallExpr initializer = new MethodCallExpr("findFirst", new Expression[0]);
        initializer.setScope((Expression)initializerScope);
        VariableDeclarator variableDeclarator = new VariableDeclarator((Type)CommonCodegenUtils.getTypedClassOrInterfaceType(Optional.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName())), OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME);
        variableDeclarator.setInitializer((Expression)initializer);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        ExpressionStmt toReturn = new ExpressionStmt();
        toReturn.setExpression((Expression)variableDeclarationExpr);
        return toReturn;
    }

    public static void addMapPopulation(Map<String, MethodDeclaration> toAdd, BlockStmt body, String mapName) {
        toAdd.forEach((s, methodDeclaration) -> {
            MethodReferenceExpr methodReferenceExpr = new MethodReferenceExpr();
            methodReferenceExpr.setScope((Expression)new ThisExpr());
            methodReferenceExpr.setIdentifier(methodDeclaration.getNameAsString());
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(s), methodReferenceExpr});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr(mapName), "put", expressions));
        });
    }

    public static MethodDeclaration getMethodDeclaration(String methodName, Map<String, ClassOrInterfaceType> parameterNameTypeMap) {
        MethodDeclaration toReturn = CommonCodegenUtils.getMethodDeclaration(methodName);
        NodeList typeParameters = new NodeList();
        parameterNameTypeMap.forEach((parameterName, classOrInterfaceType) -> {
            Parameter toAdd = new Parameter();
            toAdd.setName(parameterName);
            toAdd.setType((Type)classOrInterfaceType);
            typeParameters.add((Node)toAdd);
        });
        toReturn.setParameters(typeParameters);
        return toReturn;
    }

    public static MethodDeclaration getMethodDeclaration(String methodName) {
        MethodDeclaration toReturn = new MethodDeclaration();
        toReturn.setName(methodName);
        return toReturn;
    }

    public static ReturnStmt getReturnStmt(String returnedVariableName) {
        ReturnStmt toReturn = new ReturnStmt();
        toReturn.setExpression((Expression)new NameExpr(returnedVariableName));
        return toReturn;
    }

    public static ClassOrInterfaceType getTypedClassOrInterfaceType(String className, List<String> typesName) {
        ClassOrInterfaceType toReturn = StaticJavaParser.parseClassOrInterfaceType((String)className);
        List types = typesName.stream().map(StaticJavaParser::parseClassOrInterfaceType).collect(Collectors.toList());
        toReturn.setTypeArguments(NodeList.nodeList(types));
        return toReturn;
    }

    public static void setAssignExpressionValue(BlockStmt body, String assignExpressionName, Expression value) {
        AssignExpr assignExpr = CommonCodegenUtils.getAssignExpression(body, assignExpressionName).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", assignExpressionName, body)));
        assignExpr.setValue(value);
    }

    public static Optional<AssignExpr> getAssignExpression(BlockStmt body, String assignExpressionName) {
        List assignExprs = body.findAll(AssignExpr.class);
        return assignExprs.stream().filter(assignExpr -> assignExpressionName.equals(assignExpr.getTarget().asNameExpr().getNameAsString())).findFirst();
    }

    public static Optional<ExplicitConstructorInvocationStmt> getExplicitConstructorInvocationStmt(BlockStmt body) {
        return body.getStatements().stream().filter(statement -> statement instanceof ExplicitConstructorInvocationStmt).map(statement -> (ExplicitConstructorInvocationStmt)statement).findFirst();
    }

    public static void setExplicitConstructorInvocationArgument(ExplicitConstructorInvocationStmt constructorInvocationStmt, String parameterName, String value) {
        NameExpr parameterExpr = CommonCodegenUtils.getExplicitConstructorInvocationParameter(constructorInvocationStmt, parameterName).orElseThrow(() -> new KiePMMLException(String.format("Missing expected parameter %s in constructor invocation %s", parameterName, constructorInvocationStmt)));
        parameterExpr.setName(value);
    }

    public static Optional<NameExpr> getExplicitConstructorInvocationParameter(ExplicitConstructorInvocationStmt constructorInvocationStmt, String parameterName) {
        return constructorInvocationStmt.getArguments().stream().filter(expression -> expression instanceof NameExpr && ((NameExpr)expression).getName().asString().equals(parameterName)).map(expression -> (NameExpr)expression).findFirst();
    }

    public static Optional<MethodDeclaration> getMethodDeclaration(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, String methodName) {
        List assignExprs = classOrInterfaceDeclaration.getMethodsByName(methodName);
        return assignExprs.isEmpty() ? Optional.empty() : Optional.of(assignExprs.get(0));
    }
}

