/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.RESULT_FEATURE;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.DefineFunctionUtils;
import org.kie.pmml.compiler.commons.utils.DerivedFieldFunctionUtils;

public class KiePMMLModelFactoryUtils {
    private KiePMMLModelFactoryUtils() {
    }

    public static void setConstructorSuperNameInvocation(String generatedClassName, ConstructorDeclaration constructorDeclaration, String name) {
        constructorDeclaration.setName(generatedClassName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationArgument(superStatement, "name", String.format("\"%s\"", name));
    }

    public static void addOutputFieldsPopulation(BlockStmt body, List<KiePMMLOutputField> outputFields) {
        for (KiePMMLOutputField outputField : outputFields) {
            String targetField;
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getName()), new NameExpr("Collections.emptyList()")});
            MethodCallExpr builder = new MethodCallExpr((Expression)new NameExpr("KiePMMLOutputField"), "builder", expressions);
            if (outputField.getRank() != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(outputField.getRank().intValue())});
                builder = new MethodCallExpr((Expression)builder, "withRank", expressions);
            }
            if (outputField.getValue() != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getValue().toString())});
                builder = new MethodCallExpr((Expression)builder, "withValue", expressions);
            }
            if ((targetField = (String)outputField.getTargetField().orElse(null)) != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(targetField)});
                builder = new MethodCallExpr((Expression)builder, "withTargetField", expressions);
            }
            if (outputField.getResultFeature() != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new NameExpr(RESULT_FEATURE.class.getName() + "." + outputField.getResultFeature().toString())});
                builder = new MethodCallExpr((Expression)builder, "withResultFeature", expressions);
            }
            MethodCallExpr newOutputField = new MethodCallExpr((Expression)builder, "build");
            expressions = NodeList.nodeList((Node[])new Expression[]{newOutputField});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("outputFields"), "add", expressions));
        }
    }

    public static void addTransformationsInClassOrInterfaceDeclaration(ClassOrInterfaceDeclaration toPopulate, TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        AtomicInteger arityCounter = new AtomicInteger(0);
        Map<String, MethodDeclaration> commonDerivedFieldsMethodMap = transformationDictionary != null && transformationDictionary.getDerivedFields() != null ? DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(transformationDictionary.getDerivedFields(), arityCounter) : Collections.emptyMap();
        Map<String, MethodDeclaration> localDerivedFieldsMethodMap = localTransformations != null && localTransformations.getDerivedFields() != null ? DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(localTransformations.getDerivedFields(), arityCounter) : Collections.emptyMap();
        Map defineFunctionsMethodMap = transformationDictionary != null && transformationDictionary.getDefineFunctions() != null ? DefineFunctionUtils.getDefineFunctionsMethodMap(transformationDictionary.getDefineFunctions()) : Collections.emptyMap();
        CommonCodegenUtils.populateMethodDeclarations(toPopulate, commonDerivedFieldsMethodMap.values());
        CommonCodegenUtils.populateMethodDeclarations(toPopulate, localDerivedFieldsMethodMap.values());
        CommonCodegenUtils.populateMethodDeclarations(toPopulate, defineFunctionsMethodMap.values());
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)toPopulate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", toPopulate.getName())));
        KiePMMLModelFactoryUtils.populateTransformationsInConstructor(constructorDeclaration, commonDerivedFieldsMethodMap, localDerivedFieldsMethodMap);
    }

    static void populateTransformationsInConstructor(ConstructorDeclaration constructorDeclaration, Map<String, MethodDeclaration> commonDerivedFieldsMethodMap, Map<String, MethodDeclaration> localDerivedFieldsMethodMap) {
        CommonCodegenUtils.addMapPopulation(commonDerivedFieldsMethodMap, constructorDeclaration.getBody(), "commonTransformationsMap");
        CommonCodegenUtils.addMapPopulation(localDerivedFieldsMethodMap, constructorDeclaration.getBody(), "localTransformationsMap");
    }
}

