/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.DefineFunctionUtils;
import org.kie.pmml.compiler.commons.utils.DerivedFieldFunctionUtils;

public class KiePMMLModelFactoryUtils {
    private KiePMMLModelFactoryUtils() {
    }

    public static void setConstructorSuperNameInvocation(String generatedClassName, ConstructorDeclaration constructorDeclaration, String name) {
        constructorDeclaration.setName(generatedClassName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationArgument(superStatement, "name", String.format("\"%s\"", name));
    }

    public static void setKiePMMLModelConstructor(String generatedClassName, ConstructorDeclaration constructorDeclaration, String name, List<MiningField> miningFields, List<OutputField> outputFields) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation(generatedClassName, constructorDeclaration, name);
        BlockStmt body = constructorDeclaration.getBody();
        List<ObjectCreationExpr> miningFieldsObjectCreations = KiePMMLModelFactoryUtils.getMiningFieldsObjectCreations(miningFields);
        CommonCodegenUtils.addListPopulation(miningFieldsObjectCreations, body, "miningFields");
        List<ObjectCreationExpr> outputFieldsObjectCreations = KiePMMLModelFactoryUtils.getOutputFieldsObjectCreations(outputFields);
        CommonCodegenUtils.addListPopulation(outputFieldsObjectCreations, body, "outputFields");
    }

    public static void addKiePMMLOutputFieldsPopulation(BlockStmt body, List<KiePMMLOutputField> outputFields) {
        for (KiePMMLOutputField outputField : outputFields) {
            String targetField;
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getName()), new NameExpr("Collections.emptyList()")});
            MethodCallExpr builder = new MethodCallExpr((Expression)new NameExpr("KiePMMLOutputField"), "builder", expressions);
            if (outputField.getRank() != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(outputField.getRank().intValue())});
                builder = new MethodCallExpr((Expression)builder, "withRank", expressions);
            }
            if (outputField.getValue() != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getValue().toString())});
                builder = new MethodCallExpr((Expression)builder, "withValue", expressions);
            }
            if ((targetField = (String)outputField.getTargetField().orElse(null)) != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(targetField)});
                builder = new MethodCallExpr((Expression)builder, "withTargetField", expressions);
            }
            if (outputField.getResultFeature() != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new NameExpr(RESULT_FEATURE.class.getName() + "." + outputField.getResultFeature().toString())});
                builder = new MethodCallExpr((Expression)builder, "withResultFeature", expressions);
            }
            MethodCallExpr newOutputField = new MethodCallExpr((Expression)builder, "build");
            expressions = NodeList.nodeList((Node[])new Expression[]{newOutputField});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("kiePMMLOutputFields"), "add", expressions));
        }
    }

    public static void addTransformationsInClassOrInterfaceDeclaration(ClassOrInterfaceDeclaration toPopulate, TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        AtomicInteger arityCounter = new AtomicInteger(0);
        Map<String, MethodDeclaration> commonDerivedFieldsMethodMap = transformationDictionary != null && transformationDictionary.getDerivedFields() != null ? DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(transformationDictionary.getDerivedFields(), arityCounter) : Collections.emptyMap();
        Map<String, MethodDeclaration> localDerivedFieldsMethodMap = localTransformations != null && localTransformations.getDerivedFields() != null ? DerivedFieldFunctionUtils.getDerivedFieldsMethodMap(localTransformations.getDerivedFields(), arityCounter) : Collections.emptyMap();
        Map defineFunctionsMethodMap = transformationDictionary != null && transformationDictionary.getDefineFunctions() != null ? DefineFunctionUtils.getDefineFunctionsMethodMap(transformationDictionary.getDefineFunctions()) : Collections.emptyMap();
        CommonCodegenUtils.populateMethodDeclarations(toPopulate, commonDerivedFieldsMethodMap.values());
        CommonCodegenUtils.populateMethodDeclarations(toPopulate, localDerivedFieldsMethodMap.values());
        CommonCodegenUtils.populateMethodDeclarations(toPopulate, defineFunctionsMethodMap.values());
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)toPopulate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", toPopulate.getName())));
        KiePMMLModelFactoryUtils.populateTransformationsInConstructor(constructorDeclaration, commonDerivedFieldsMethodMap, localDerivedFieldsMethodMap);
    }

    static List<ObjectCreationExpr> getMiningFieldsObjectCreations(List<MiningField> miningFields) {
        return miningFields.stream().map(miningField -> {
            ObjectCreationExpr toReturn = new ObjectCreationExpr();
            toReturn.setType(MiningField.class.getCanonicalName());
            StringLiteralExpr name = miningField.getName() != null ? new StringLiteralExpr(miningField.getName()) : new NullLiteralExpr();
            FIELD_USAGE_TYPE fieldUsageType = miningField.getUsageType();
            NameExpr usageType = fieldUsageType != null ? new NameExpr(fieldUsageType.getClass().getName() + "." + fieldUsageType.name()) : new NullLiteralExpr();
            OP_TYPE oPT = miningField.getOpType();
            NameExpr opType = oPT != null ? new NameExpr(oPT.getClass().getName() + "." + oPT.name()) : new NullLiteralExpr();
            toReturn.setArguments(NodeList.nodeList((Node[])new Expression[]{name, usageType, opType}));
            return toReturn;
        }).collect(Collectors.toList());
    }

    static List<ObjectCreationExpr> getOutputFieldsObjectCreations(List<OutputField> outputFields) {
        return outputFields.stream().map(outputField -> {
            ObjectCreationExpr toReturn = new ObjectCreationExpr();
            toReturn.setType(OutputField.class.getCanonicalName());
            StringLiteralExpr name = outputField.getName() != null ? new StringLiteralExpr(outputField.getName()) : new NullLiteralExpr();
            OP_TYPE oPT = outputField.getOpType();
            NameExpr opType = oPT != null ? new NameExpr(oPT.getClass().getName() + "." + oPT.name()) : new NullLiteralExpr();
            DATA_TYPE datT = outputField.getDataType();
            NameExpr dataType = datT != null ? new NameExpr(datT.getClass().getName() + "." + datT.name()) : new NullLiteralExpr();
            StringLiteralExpr targetField = outputField.getTargetField() != null ? new StringLiteralExpr(outputField.getTargetField()) : new NullLiteralExpr();
            RESULT_FEATURE rsltF = outputField.getResultFeature();
            NameExpr resultFeature = rsltF != null ? new NameExpr(rsltF.getClass().getName() + "." + rsltF.name()) : new NullLiteralExpr();
            toReturn.setArguments(NodeList.nodeList((Node[])new Expression[]{name, opType, dataType, targetField, resultFeature}));
            return toReturn;
        }).collect(Collectors.toList());
    }

    static void populateTransformationsInConstructor(ConstructorDeclaration constructorDeclaration, Map<String, MethodDeclaration> commonDerivedFieldsMethodMap, Map<String, MethodDeclaration> localDerivedFieldsMethodMap) {
        CommonCodegenUtils.addMapPopulation(commonDerivedFieldsMethodMap, constructorDeclaration.getBody(), "commonTransformationsMap");
        CommonCodegenUtils.addMapPopulation(localDerivedFieldsMethodMap, constructorDeclaration.getBody(), "localTransformationsMap");
    }
}

